% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxlib_open_file.R
\name{pxlib_open_file}
\alias{pxlib_open_file}
\title{Open a Paradox Database File}
\usage{
pxlib_open_file(path, encoding = NULL)
}
\arguments{
\item{path}{A character string specifying the path to the Paradox (.db) file.}

\item{encoding}{An optional character string specifying the input encoding of
the data (e.g., "cp866", "cp1252"). If \code{NULL} (the default), the encoding
is determined from the file header.}
}
\value{
An external pointer of class 'pxdoc_t' if the file is successfully
opened, or \code{NULL} if an error occurs (e.g., file not found).
}
\description{
Opens a Paradox database (.db) file and prepares it for reading. This function
serves as the entry point for interacting with a Paradox database.
}
\details{
This function initializes a connection to a Paradox file via the underlying C library.
It automatically performs two key setup tasks:
\enumerate{
\item \strong{Encoding Override:} It allows the user to specify the character encoding of the
source file via the \code{encoding} parameter. This is crucial for legacy files
where the encoding stored in the header may be incorrect. If \code{encoding} is
\code{NULL}, the function will attempt to use the codepage from the file header.
\item \strong{BLOB File Attachment:} It automatically searches for an associated BLOB file
(with a \code{.mb} extension, case-insensitively) in the same directory and,
if found, attaches it to the database handle.
}
}
\examples{
# Example 1: Open a bundled demo file (biolife.db)
db_path <- system.file("extdata", "biolife.db", package = "Rparadox")
pxdoc <- pxlib_open_file(db_path)
if (!is.null(pxdoc)) {
  # normally you'd read data here
  pxlib_close_file(pxdoc)
}

# Example 2: Open a file with overridden encoding (of_cp866.db)
db_path2 <- system.file("extdata", "of_cp866.db", package = "Rparadox")
pxdoc2 <- pxlib_open_file(db_path2, encoding = "cp866")
if (!is.null(pxdoc2)) {
  # read some data ...
  pxlib_close_file(pxdoc2)
}
}
