% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations.add.R
\name{organizations.add}
\alias{organizations.add}
\title{Add an organization}
\usage{
organizations.add(name, owner_id = NULL, visible_to = NULL,
  add_time = NULL, customList = NULL, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{name}{Organization name}

\item{owner_id}{ID of the user who will be marked as the owner of this organization. When omitted, the authorized user ID will be used.}

\item{visible_to}{Visibility of the organization. If omitted, visibility will be set to the default visibility setting of this item type for the authorized user.1 = Owner & followers (private); 3 = Entire company (shared) This field has the following domains: (1; 3)}

\item{add_time}{Optional creation date & time of the organization in UTC. Requires admin user API token. Format: YYYY-MM-DD HH:MM:SS}

\item{customList}{List with custom fields. Example: list(`custom_field` = abc)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Add an organization on pipedrive.
}
\examples{
\donttest{
organizations.add(name='e.g.',api_token='token',company_domain='exp')
}
}
