% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_normalization.R
\name{RprobitB_normalization}
\alias{RprobitB_normalization}
\title{Create object of class \code{RprobitB_normalization}.}
\usage{
RprobitB_normalization(
  J,
  P_f,
  level = J,
  scale = list(parameter = "s", index = 1, value = 1)
)
}
\arguments{
\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{level}{The number of the alternative with respect which utility differences are
computed. Currently, only \code{level = J} (i.e. utility differences with
respect to the last alternative) is implemented.}

\item{scale}{A named list of three elements, determining the parameter normalization with
respect to the utility scale:
\itemize{
\item \code{parameter}:
Either \code{"a"} (for a linear coefficient of \code{"alpha"}) or
\code{"s"} (for a variance of the error-term covariance matrix
\code{"Sigma"}).
\item \code{index}:
The index of the parameter that gets fixed.
\item \code{value}:
The value for the fixed parameter.
}}
}
\value{
An object of class \code{RprobitB_normalization}, which is a list of the
elements \code{level} and \code{scale}.
}
\description{
This function creates an object of class \code{RprobitB_normalization}.
}
\details{
Any choice model has to be normalized with respect to level and scale.
\itemize{
\item For level normalization, we takes utility differences with respect to
one alternative.
\item For scale normalization, we fix a model parameter. Per default, the
first error-term variance is fixed to \code{1}, i.e.
\code{scale = list("parameter" = "s", "index" = 1, "value" = 1)}.
Alternatively, any error-term variance or any linear coefficient can
be fixed.
}
}
\keyword{s3}
