% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_distr.R
\name{check_distr}
\alias{check_distr}
\title{Check \code{distr}.}
\usage{
check_distr(distr)
}
\arguments{
\item{distr}{A named list of number generation functions from which the covariates are
drawn. Covariates for which no distribution is specified are drawn from a
standard normal distribution.
Each element of \code{distr} must be of the form
\code{"cov" = list("name" = "<name of the number generation function>",...)},
where \code{cov} is the name of the covariate and \code{...} are required
parameters for the number generation function.
Possible number generation functions are
\itemize{
\item functions of the type \code{r*} from base R (e.g. \code{rnorm}) where
all required parameters (except for \code{n}) must be specified,
\item the function \code{sample}, where all required parameters
(except for \code{size}) must be specified.
}}
}
\value{
The checked input \code{distr}.
}
\description{
This function checks the input \code{distr}.
}
\keyword{internal}
