% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc}
\alias{mcmc}
\title{Perform Markov chain Monte Carlo simulation for fitting a (latent class)
(mixed) (multinomial) probit model.}
\usage{
mcmc(
  data,
  scale = list(parameter = "s", index = 1, value = 1),
  R = 10000,
  B = R/2,
  Q = 1,
  print_progress = TRUE,
  prior = NULL,
  latent_classes = NULL,
  seed = NULL
)
}
\arguments{
\item{data}{An object of class \code{RprobitB_data}.}

\item{scale}{A named list of three elements, determining the parameter normalization with
respect to the utility scale:
\itemize{
\item \code{parameter}:
Either \code{"a"} (for a linear coefficient of \code{"alpha"}) or
\code{"s"} (for a variance of the error-term covariance matrix
\code{"Sigma"}).
\item \code{index}:
The index of the parameter that gets fixed.
\item \code{value}:
The value for the fixed parameter.
}}

\item{R}{The number of iterations of the Gibbs sampler.}

\item{B}{The length of the burn-in period, i.e. a non-negative number of samples to
be discarded.}

\item{Q}{The thinning factor for the Gibbs samples, i.e. only every \code{Q}th
sample is kept.}

\item{print_progress}{A boolean, determining whether to print the Gibbs sampler progress and the
estimated remaining computation time.}

\item{prior}{A named list of parameters for the prior distributions of the normalized
parameters:
\itemize{
\item \code{eta}:
The mean vector of length \code{P_f} of the normal prior for
\code{alpha}.
\item \code{Psi}:
The covariance matrix of dimension \code{P_f} x \code{P_f} of the
normal prior for \code{alpha}.
\item \code{delta}:
The concentration parameter of length 1 of the Dirichlet prior for
\code{s}.
\item \code{xi}:
The mean vector of length \code{P_r} of the normal prior for each
\code{b_c}.
\item \code{D}:
The covariance matrix of dimension \code{P_r} x \code{P_r} of the
normal prior for each \code{b_c}.
\item \code{nu}:
The degrees of freedom (a natural number greater than \code{P_r}) of
the Inverse Wishart prior for each \code{Omega_c}.
\item \code{Theta}:
The scale matrix of dimension \code{P_r} x \code{P_r} of the
Inverse Wishart prior for each \code{Omega_c}.
\item \code{kappa}:
The degrees of freedom (a natural number greater than \code{J-1}) of
the Inverse Wishart prior for \code{Sigma}.
\item \code{E}:
The scale matrix of dimension \code{J-1} x \code{J-1} of the
Inverse Wishart prior for \code{Sigma}.
}}

\item{latent_classes}{Either \code{NULL} or a list of parameters specifying the number and the
latent classes:
\itemize{
\item \code{C}:
The number (greater or equal 1) of latent classes, which is set to 1 per
default and is ignored if \code{P_r = 0}.
If \code{update = TRUE}, \code{C} equals the initial number of classes.
\item \code{update}:
A boolean, determining whether to update \code{C}.
Ignored if \code{P_r = 0}.
If \code{update = FALSE}, all of the following elements are ignored.
\item \code{Cmax}:
The maximum number of latent classes.
\item \code{buffer}:
The updating buffer (number of iterations to wait before the next update).
\item \code{epsmin}:
The threshold weight for removing latent classes (between 0 and 1).
\item \code{epsmax}:
The threshold weight for splitting latent classes (between 0 and 1).
\item \code{distmin}:
The threshold difference in means for joining latent classes
(non-negative).
}}

\item{seed}{Set a seed for the Gibbs sampling.}
}
\value{
An object of class \code{RprobitB_model}.
}
\description{
This function performs Markov chain Monte Carlo simulation for fitting a
(latent class) (mixed) (multinomial) probit model to discrete choice data.
}
\details{
See the vignette "Model fitting" for more details:
\code{vignette("model_fitting", package = "RprobitB")}.
}
\examples{
\dontrun{
### probit model
p = simulate(form = choice ~ var | 0, N = 100, T = 10, J = 2, seed = 1)
m1 = mcmc(data = p, seed = 1)

### multinomial probit model
mnp = simulate(form = choice ~ var | 0, N = 100, T = 10, J = 3, seed = 1)
m2 = mcmc(data = mnp, seed = 1)

### mixed multinomial probit model
mmnp = simulate(form = choice ~ 0 | var, N = 100, T = 10, J = 3, re = "var",
                seed = 1)
m3 = mcmc(data = mmnp, seed = 1)

### mixed multinomial probit model with 2 latent classes
lcmmnp = simulate(form = choice ~ 0 | var, N = 100, T = 10, J = 3,
                  re = "var", seed = 1, C = 2)
m4 = mcmc(data = lcmmnp, latent_classes = list("C" = 2), seed = 1)

### update of latent classes
m5 = mcmc(data = lcmmnp, latent_classes = list("update" = TRUE), seed = 1)
}
}
