% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_management.R
\name{create_lagged_cov}
\alias{create_lagged_cov}
\title{Create lagged choice covariates}
\usage{
create_lagged_cov(choice_data, column, k = 1, id = "id")
}
\arguments{
\item{choice_data}{A \code{data.frame} of choice data in wide format, i.e. each row represents
one choice occasion.}

\item{column}{A character, the column name in \code{choice_data}, i.e. the covariate name.
Can be a vector.}

\item{k}{A positive number, the number of lags (in units of observations), see the
details. Can be a vector. The default is \code{k = 1}.}

\item{id}{A character, the name of the column in \code{choice_data} that contains
unique identifier for each decision maker. The default is \code{"id"}.}
}
\value{
The input \code{choice_data} with the additional columns named
\code{column.k} for each element \code{column} and each number \code{k}
containing the lagged covariates.
}
\description{
This function creates lagged choice covariates from the \code{data.frame}
\code{choice_data}, which is assumed to be sorted by the choice occasions.
}
\details{
Say that \code{choice_data} contains the column \code{column}. Then, the
function call
\preformatted{
create_lagged_cov(choice_data, column, k, id)
}
returns the input \code{choice_data} which includes a new column named
\code{column.k}. This column contains for each decider (based on \code{id})
and each choice occasion the covariate faced before \code{k} choice
occasions. If this data point is not available, it is set to
\code{NA}. In particular, the first \code{k} values of \code{column.k} will
be \code{NA} (initial condition problem).
}
