% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{filter_gibbs_samples}
\alias{filter_gibbs_samples}
\title{Filter Gibbs samples}
\usage{
filter_gibbs_samples(
  x,
  P_f,
  P_r,
  J,
  C,
  cov_sym,
  ordered = FALSE,
  keep_par = c("s", "alpha", "b", "Omega", "Sigma", "d"),
  drop_par = NULL
)
}
\arguments{
\item{x}{An object of class \code{RprobitB_gibbs_samples}.}

\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{cov_sym}{Set to \code{TRUE} for labels of symmetric covariance elements.}

\item{ordered}{A boolean, \code{FALSE} per default. If \code{TRUE}, the choice set
\code{alternatives} is assumed to be ordered from worst to best.}

\item{keep_par}{A vector of parameter names which are kept.}

\item{drop_par}{A vector of parameter names which get dropped.}
}
\value{
An object of class \code{RprobitB_gibbs_samples} filtered by the labels of
\code{\link{parameter_labels}}.
}
\description{
This is a helper function that filters Gibbs samples.
}
\keyword{internal}
