% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{train_choice}
\alias{train_choice}
\title{Stated Preferences for Train Traveling}
\format{
A \code{data.frame} with 2929 rows and 11 columns:
\describe{
\item{deciderID}{\code{integer} identifier for the decider}
\item{occasionID}{\code{integer} identifier for the choice occasion}
\item{choice}{\code{character} for the chosen alternative (either \code{"A"} or \code{"B"})}
\item{price_A}{\code{numeric} price for alternative \code{"A"} in Euro}
\item{time_A}{\code{numeric} travel time for alternative \code{"A"} in hours}
\item{change_A}{\code{integer} number of changes for alternative \code{"A"}}
\item{comfort_A}{\code{integer} comfort level (in decreasing comfort order) for alternative \code{"A"}}
\item{price_B}{\code{numeric} price for alternative \code{"B"} in Euro}
\item{time_B}{\code{numeric} travel time for alternative \code{"B"} in hours}
\item{change_B}{\code{integer} number of changes for alternative \code{"B"}}
\item{comfort_B}{\code{integer} comfort level (in decreasing comfort order) for alternative \code{"B"}}
}
}
\usage{
train_choice
}
\description{
Data set of 2929 stated choices by 235 Dutch individuals deciding between
two virtual train trip options \code{"A"} and \code{"B"} based on the price,
the travel time, the number of rail-to-rail transfers (changes), and the
level of comfort.

The data were obtained in 1987 by Hague Consulting Group for the National
Dutch Railways. Prices were recorded in Dutch guilder and in this data set
transformed to Euro at an exchange rate of 2.20371 guilders = 1 Euro.
}
\references{
\insertRef{BenAkiva1993}{RprobitB}

\insertRef{Meijer2006}{RprobitB}
}
\keyword{dataset}
