% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXmlFile.R
\name{readXmlFile}
\alias{readXmlFile}
\title{Read fisheries XML data format file}
\usage{
readXmlFile(
  xmlFilePath,
  stream = TRUE,
  useXsd = NULL,
  usePrefix = NULL,
  verbose = FALSE
)
}
\arguments{
\item{xmlFilePath}{full path to the XML file to be read.}

\item{stream}{a streaming XML pull parser is used if this is set to TRUE. An XML DOM parser is used if this is set to FALSE. Default to TRUE.}

\item{useXsd}{Specify an xsd object to use. Default to NULL.}

\item{usePrefix}{Manually specify a namespace prefix. Default to NULL.}

\item{verbose}{Show verbose output. Default to FALSE.}
}
\value{
List of data.table objects containing the "flattened" XML data.
}
\description{
Read fisheries XML data format file. Currently supports IMR Biotic version 1 until 3, IMR Echosounder version 1, and IMR Landing version 2 formats at the moment.
Streaming XML pull parser can be used to avoid loading the whole XML into memory and it supports ZIP file reading. Please note that
the XML file inside the zip file should be using the same name as the zip file itself (e.g. test.xml inside test.zip).
}
\examples{
\dontrun{
# Reading test.xml using XML pull parser
one <- readXmlFile("./test.xml")
# Reading test.xml using XML DOM parser
two <- readXmlFile("./test.xml", stream = FALSE)
# Reading test.xml inside test.zip file
three <- readXmlFile("./test.zip")
}

}
