% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{tsEvaPlotGPDImageScFromAnalysisObj}
\alias{tsEvaPlotGPDImageScFromAnalysisObj}
\title{tsEvaPlotGPDImageScFromAnalysisObj}
\usage{
tsEvaPlotGPDImageScFromAnalysisObj(
  Y,
  nonStationaryEvaParams,
  stationaryTransformData,
  trans,
  ...
)
}
\arguments{
\item{Y}{The input data.}

\item{nonStationaryEvaParams}{A list containing non-stationary evaluation parameters.}

\item{stationaryTransformData}{A data frame containing stationary transform data.}

\item{trans}{The transformation method to be applied to the data.}

\item{...}{Additional arguments to be passed to the \code{\link{tsEvaPlotGPDImageSc}} function.}
}
\value{
The plot object.
}
\description{
\code{tsEvaPlotGPDImageScFromAnalysisObj}is a function that plots the GPD
(Generalized Pareto Distribution) time-varying distribution through time as
and show the evolution of exceedance probabilities.
}
\details{
This function takes the input data \code{Y}, non-stationary evaluation parameters \code{nonStationaryEvaParams},
stationary transform data \code{stationaryTransformData}, transformation method \code{trans}, and additional arguments \code{...}.
It then updates the arguments with the passed-in values, calculates the time stamps, and performs necessary transformations.
Finally, it plots the GPD image score using the \code{\link{tsEvaPlotGPDImageSc}} function and returns the plot object.
}
\examples{
# Example usage of TsEvaNs function
timeAndSeries <- ArdecheStMartin
#go from six-hourly values to daily max
timeAndSeries <- max_daily_value(timeAndSeries)
#keep only the 20 last years
yrs <- as.integer(format(timeAndSeries$date, "\%Y"))
tokeep <- which(yrs>=2000)
timeAndSeries <- timeAndSeries[tokeep,]
timeWindow <- 5*365 # 5 years
TSEVA_data <- TsEvaNs(timeAndSeries, timeWindow,
transfType = 'trendPeaks',tail = 'high')
nonStationaryEvaParams <- TSEVA_data[[1]]
stationaryTransformData <- TSEVA_data[[2]]
trans='ori'
ExRange= c(min(nonStationaryEvaParams$potObj$parameters$peaks),
max(nonStationaryEvaParams$potObj$parameters$peaks))
Y <- c(seq(min(ExRange),max(ExRange),length.out=700))
result = tsEvaPlotGEVImageScFromAnalysisObj(Y, nonStationaryEvaParams,
stationaryTransformData, trans)
result

}
\seealso{
\code{\link{tsEvaPlotGPDImageSc}}
}
