% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgPlatonic.r
\name{vcgSphere}
\alias{vcgSphere}
\alias{vcgSphericalCap}
\alias{vcgTetrahedron}
\alias{vcgDodecahedron}
\alias{vcgOctahedron}
\alias{vcgIcosahedron}
\alias{vcgHexahedron}
\alias{vcgSquare}
\alias{vcgBox}
\alias{vcgCone}
\title{create platonic objects as triangular meshes}
\usage{
vcgSphere(subdivision = 3, normals = TRUE)

vcgSphericalCap(angleRad = pi/2, subdivision = 3, normals = TRUE)

vcgTetrahedron(normals = TRUE)

vcgDodecahedron(normals = TRUE)

vcgOctahedron(normals = TRUE)

vcgIcosahedron(normals = TRUE)

vcgHexahedron(normals = TRUE)

vcgSquare(normals = TRUE)

vcgBox(mesh = vcgSphere(), normals = TRUE)

vcgCone(r1, r2, h, normals = TRUE)
}
\arguments{
\item{subdivision}{subdivision level for sphere (the larger the denser the mesh will be)}

\item{normals}{if TRUE vertex normals are calculated}

\item{angleRad}{angle of the spherical cap}

\item{mesh}{mesh to take the bounding box from}

\item{r1}{radius1 of the cone}

\item{r2}{radius2 of the cone}

\item{h}{height of the cone}
}
\description{
create platonic objects as triangular meshes
}
