% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xnat_api.R
\name{query_scan_resources}
\alias{query_scan_resources}
\title{Query all XNAT scan resources}
\usage{
query_scan_resources(conn, ...)
}
\arguments{
\item{conn}{The XNAT connection returned by a \code{xnat_connect} call}

\item{...}{Select query parameters: subject_ID, project, age, experiment_ID, type
TR, TE, TI, flip, voxel_res, voxel_res_X, voxel_res_Y, voxel_res_Z,
orientation}
}
\value{
A data.frame containing all matching rows. XNAT does not do 
sql join joins so only one row is returned per match. However each of the 
experiment_IDs returned will have at least one row matching the user
query (even if the displayed results show something else). This function
should be used just to retrieve matching experiment IDs for downloading
the queried data.
}
\description{
Query all scan resources to match
specific query parameters and return a list of all
matching rows
}
\examples{
\dontrun{hcp <-xnat_connect('https://db.humanconnectome.org', xnat_name = "hcp")}
\dontrun{query_scan_resources(hcp,age='26', project='HCP_500')}
}
