% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_DD.R
\name{DD_TMB}
\alias{DD_TMB}
\alias{DD_SS}
\title{Delay - Difference Stock Assessment in TMB}
\usage{
DD_TMB(
  x = 1,
  Data,
  condition = c("catch", "effort"),
  AddInd = "B",
  SR = c("BH", "Ricker"),
  rescale = "mean1",
  start = NULL,
  fix_h = TRUE,
  dep = 1,
  LWT = NULL,
  silent = TRUE,
  opt_hess = FALSE,
  n_restart = ifelse(opt_hess, 0, 1),
  control = list(iter.max = 5000, eval.max = 10000),
  ...
)

DD_SS(
  x = 1,
  Data,
  condition = c("catch", "effort"),
  AddInd = "B",
  SR = c("BH", "Ricker"),
  rescale = "mean1",
  start = NULL,
  fix_h = TRUE,
  fix_sd = FALSE,
  fix_tau = TRUE,
  dep = 1,
  LWT = NULL,
  integrate = FALSE,
  silent = TRUE,
  opt_hess = FALSE,
  n_restart = ifelse(opt_hess, 0, 1),
  control = list(iter.max = 5000, eval.max = 10000),
  inner.control = list(),
  ...
)
}
\arguments{
\item{x}{An index for the objects in \code{Data} when running in closed loop simulation.
Otherwise, equals to 1 when running an assessment.}

\item{Data}{An object of class \linkS4class{Data}.}

\item{condition}{A string to indicate whether to condition the model on catch or effort (ratio of catch and index).}

\item{AddInd}{A vector of integers or character strings indicating the indices to be used in the model. Integers assign the index to
the corresponding index in Data@AddInd, "B" (or 0) represents total biomass in Data@Ind, "VB" represents vulnerable biomass in
Data@VInd, and "SSB" represents spawning stock biomass in Data@SpInd.}

\item{SR}{Stock-recruit function (either \code{"BH"} for Beverton-Holt or \code{"Ricker"}).}

\item{rescale}{A multiplicative factor that rescales the catch in the assessment model, which
can improve convergence. By default, \code{"mean1"} scales the catch so that time series mean is 1, otherwise a numeric.
Output is re-converted back to original units.}

\item{start}{Optional list of starting values. Entries can be expressions that are evaluated in the function. See details.}

\item{fix_h}{Logical, whether to fix steepness to value in \code{Data@steep} in the assessment model.}

\item{dep}{The initial depletion in the first year of the model. A tight prior is placed on the model objective function
to estimate the equilibrium exploitation rate that corresponds to the initial depletion. Due to this tight prior, this F
should not be considered to be an independent model parameter.}

\item{LWT}{A vector of likelihood weights for each survey.}

\item{silent}{Logical, passed to \code{\link[TMB]{MakeADFun}}, whether TMB
will print trace information during optimization. Used for diagnostics for model convergence.}

\item{opt_hess}{Logical, whether the hessian function will be passed to \code{\link[stats]{nlminb}} during optimization
(this generally reduces the number of iterations to convergence, but is memory and time intensive and does not guarantee an increase
in convergence rate). Ignored if \code{integrate = TRUE}.}

\item{n_restart}{The number of restarts (calls to \code{\link[stats]{nlminb}}) in the optimization procedure, so long as the model
hasn't converged. The optimization continues from the parameters from the previous (re)start.}

\item{control}{A named list of parameters regarding optimization to be passed to
\code{\link[stats]{nlminb}}.}

\item{...}{Additional arguments (not currently used).}

\item{fix_sd}{Logical, whether the standard deviation of the data in the likelihood (index for conditioning on catch or
catch for conditioning on effort). If \code{TRUE}, the SD is fixed to value provided in \code{start} (if provided), otherwise,
 value based on either \code{Data@CV_Cat} or \code{Data@CV_Ind}.}

\item{fix_tau}{Logical, the standard deviation of the recruitment deviations is fixed. If \code{TRUE},
tau is fixed to value provided in \code{start} (if provided), otherwise, equal to 1.}

\item{integrate}{Logical, whether the likelihood of the model integrates over the likelihood
of the recruitment deviations (thus, treating it as a random effects/state-space variable).
Otherwise, recruitment deviations are penalized parameters.}

\item{inner.control}{A named list of arguments for optimization of the random effects, which
is passed on to \code{\link[TMB]{newton}} via \code{\link[TMB]{MakeADFun}}.}
}
\value{
An object of \code{\linkS4class{Assessment}} containing objects and output from TMB.
}
\description{
A simple delay-difference assessment model using a
time-series of catches and a relative abundance index and coded in TMB. The model
can be conditioned on either (1) effort and estimates predicted catch or (2) catch and estimates a predicted index.
In the state-space version \code{DD_SS}, recruitment deviations from the stock-recruit relationship are estimated.
}
\details{
For \code{start} (optional), a named list of starting values of estimates can be provided for:
\itemize{
\item \code{R0} Unfished recruitment. Otherwise, Data@OM$R0[x] is used in closed-loop, and 400\% of mean catch otherwise.
\item \code{h} Steepness. Otherwise, Data@steep[x] is used, or 0.9 if empty.
\item \code{q_effort} Scalar coefficient when conditioning on effort (to scale to F). Otherwise, 1 is the default.
\item \code{U_equilibrium} Equilibrium harvest rate leading into first year of the model (to determine initial depletion). By default, 0.
\item \code{omega} Lognormal SD of the catch (observation error) when conditioning on effort. By default, Data@CV_Cat[x].
\item \code{tau} Lognormal SD of the recruitment deviations (process error) for \code{DD_SS}. By default, Data@sigmaR[x].
\item \code{sigma} Lognormal SD of the index (observation error) when conditioning on catch. By default, Data@CV_Ind[x]. Not
used if multiple indices are used.
}

Multiple indices are supported in the model. Data@Ind, Data@VInd, and Data@SpInd are all assumed to be biomass-based.
For Data@AddInd, Data@I_units are used to identify a biomass vs. abundance-based index.

Similar to many other assessment
models, the model depends on assumptions such as stationary productivity and
proportionality between the abundance index and real abundance.
Unsurprisingly the extent to which these assumptions are
violated tends to be the biggest driver of performance for this method.
}
\section{Required Data}{

\itemize{
\item \code{DD_TMB}: Cat, Ind, Mort, L50, vbK, vbLinf, vbt0, wla, wlb, MaxAge
\item \code{DD_SS}: Cat, Ind, Mort, L50, vbK, vbLinf, vbt0, wla, wlb, MaxAge
}
}

\section{Optional Data}{

\itemize{
\item \code{DD_TMB}: steep
\item \code{DD_SS}: steep, CV_Cat
}
}

\examples{
\donttest{
#### Observation-error delay difference model
res <- DD_TMB(x = 3, Data = MSEtool::SimulatedData)

# Provide starting values
start <- list(h = 0.95)
res <- DD_TMB(x = 3, Data = MSEtool::SimulatedData, start = start)

summary(res@SD) # Parameter estimates

### State-space version
### Set recruitment variability SD = 0.3 (since fix_tau = TRUE)
res <- DD_SS(x = 3, Data = MSEtool::SimulatedData, start = list(tau = 0.3))
}
}
\references{
Carruthers, T, Walters, C.J,, and McAllister, M.K. 2012. Evaluating methods that classify
fisheries stock status using only fisheries catch data. Fisheries Research 119-120:66-79.

Hilborn, R., and Walters, C., 1992. Quantitative Fisheries Stock Assessment: Choice,
Dynamics and Uncertainty. Chapman and Hall, New York.
}
\seealso{
\link{plot.Assessment} \link{summary.Assessment} \link{retrospective} \link{profile} \link{make_MP}
}
\author{
T. Carruthers & Z. Siders. Zach Siders coded the TMB function.
}
