% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCM2MOM.R
\name{RCM2MOM}
\alias{RCM2MOM}
\title{Convert RCM to a multi-fleet operating model (MOM)}
\usage{
RCM2MOM(RCModel)
}
\arguments{
\item{RCModel}{Output from \link{RCM}, a class \linkS4class{RCModel} object.}
}
\value{
A class \link[MSEtool:MOM-class]{MSEtool::MOM} object.
}
\description{
The RCM (Rapid Conditioning Model) returns a single-fleet operating model, implying constant effort among fleets for projections.
Here, we convert the single-fleet OM to a multi-fleet OM, preserving the multiple fleet structure used in the conditioning model
for projections. This allows for testing management procedures that explicitly specify fleet allocation in the management advice.
}
\examples{
\donttest{
data(pcod) 
mat_ogive <- pcod$OM@cpars$Mat_age[1, , 1]
OM <- MSEtool::SubCpars(pcod$OM, 1:3)
out <- RCM(OM = pcod$OM, data = pcod$data, 
           condition = "catch", mean_fit = TRUE,
           selectivity = "free", s_selectivity = rep("SSB", ncol(pcod$data@Index)),
           start = list(vul_par = matrix(mat_ogive, length(mat_ogive), 1)),
           map = list(vul_par = matrix(NA, length(mat_ogive), 1),
                      log_early_rec_dev = rep(1, pcod$OM@maxage)),
           prior = pcod$prior)
MOM <- RCM2MOM(out)
}

}
\author{
Q. Huynh
}
