% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistart.R
\name{extract_best}
\alias{extract_best}
\title{Extract the best run from multiple trials}
\usage{
extract_best(object)
}
\arguments{
\item{object}{an object of class \code{multistart}, obtained from the \code{variational_multistart} function.}
}
\value{
the single best run, an object of class \code{SANvb}.
}
\description{
A simple function to automatically extract the best run from a collection of fitted variational models.
}
\examples{
\donttest{
# Generate example dataset
set.seed(123)
y <- c(rnorm(100),rnorm(100,5))
g <- rep(1:2,rep(100,2))

# Estimate multiple models via variational inference
est <- variational_multistart(y, g, runs=5,
                              alpha_bar = 3, beta_bar = 3,
                              root=1234, warmstart = FALSE)

# Obtain best run
extract_best(est)
}
}
