% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_adjust.R
\name{cor.genes}
\alias{cor.genes}
\alias{cor.cells}
\title{Calculates gene-to-gene and cell-to-cell SAVER correlation}
\usage{
cor.genes(x, cor.mat = NULL)

cor.cells(x, cor.mat = NULL)
}
\arguments{
\item{x}{A \code{saver} object.}

\item{cor.mat}{If a correlation matrix of the SAVER estimates was already
obtained, then it can be provided as an input to avoid recomputation.}
}
\value{
An adjusted correlation matrix.
}
\description{
Adjusts for SAVER estimation uncertainty by calculating and adjusting
gene-to-gene and cell-to-cell correlation matrices
}
\details{
The SAVER estimates that are produced have varying levels of uncertainty
depending on the gene and the cell. These functions adjust the gene-to-gene
and cell-to-cell correlations of the SAVER estimates to reflect the
estimation uncertainty.
}
\examples{
data("linnarsson_saver")

gene.cor <- cor.genes(linnarsson_saver)

}
