% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.R2D2.R
\name{R2D2}
\alias{R2D2}
\title{R2D2 (Rank Resampling for Distributions and Dependences) method}
\description{
Perform a multivariate (non stationary) bias correction.
}
\details{
Use rankshuffle in calibration and projection period with CDFt
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period
X1 = XY$X1 ## Biased in projection period

## Bias correction
## Step 1 : construction of the class R2D2 
r2d2 = SBCK::R2D2$new() 
## Step 2 : Fit the bias correction model
r2d2$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction
Z = r2d2$predict(X1,X0) 

}
\references{
Vrac, M.: Multivariate bias adjustment of high-dimensional
            climate simulations: the Rank Resampling for Distributions and
            Dependences (R2 D2 ) bias correction, Hydrol. Earth Syst. Sci.,
            22, 3175–3196, https://doi.org/10.5194/hess-22-3175-2018, 2018.
}
\section{Super class}{
\code{\link[SBCK:CDFt]{SBCK::CDFt}} -> \code{R2D2}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{irefs}}{[vector of int] Indexes for shuffle. Defaults is base::c(1)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{R2D2$new()}}
\item \href{#method-fit}{\code{R2D2$fit()}}
\item \href{#method-predict}{\code{R2D2$predict()}}
\item \href{#method-clone}{\code{R2D2$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new R2D2 object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R2D2$new(irefs = base::c(1), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{irefs}}{[vector of int] Indexes for shuffle. Defaults is base::c(1)
model}

\item{\code{...}}{[] all others arguments are passed to CDFt class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `R2D2` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R2D2$fit(Y0, X0, X1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R2D2$predict(X1, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL, else return a list containing Z1 and Z0,
                         the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R2D2$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
