% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCalgo.R
\name{SCalgo}
\alias{SCalgo}
\title{Splitting-Coalescence (SC) algorithm.}
\usage{
SCalgo(paths, bandwidth)
}
\arguments{
\item{paths}{A list of data frames, where each frame contains the data for one individual. There
should be two columns with names 'distance' and 'oxygen'.}

\item{bandwidth}{Denotes the order of the bandwidth that should be used in the splitting-coalescence
(SC) clustering algorithm. A value k will mean that the bandwidth used in the algorithm is n^k.}
}
\value{
A list of vectors where each vector gives the indexes of the individuals to be assigned
in the same cluster.
}
\description{
This function performs the iterative clustering algorithm on the archaeological time series data. Detailed description can be found in Chazin et al. 2019, Supplemental Materials 1.
}
\examples{
\dontrun{
armenia_split = split(armenia,f = armenia$ID)
band = -0.33
results = SCalgo(armenia_split,bandwidth = band)
}
}
