% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{outlier_filter}
\alias{outlier_filter}
\title{Outlier detection}
\usage{
outlier_filter(dist)
}
\arguments{
\item{dist}{A numeric matrix, data frame or "\code{dist}" object.}
}
\value{
A boolean vector indicating whether samples are \emph{not} outliers.
}
\description{
\code{outlier_filter} calculates which samples are outliers by iteratively
removing the samples with the highest \emph{outlierness}' and fitting a normal distribution
to the remaining outlierness values. A selection of samples is made by picking the iteration
at which the log likelihood is maximised.
}
\examples{
\dontrun{
## Generate normally distributed points, calculate their outliernesses and which points are outliers
x <- matrix(rnorm(200*2), ncol=2)
dist <- euclidean_distance(x)
filt <- outlier_filter(dist)
# plot points using their outlierness value as size and whether or not they were outliers as colours
plot(x, col=filt+2, cex=outlierness(dist)+1, pch=20)
# plot the score at each iteration of the removal process
likelihood_df <- attr(filt, "loglikelihood")
plot(likelihood_df$amount_removed, likelihood_df$log_likelihood, type="l")

## Generate a random expression dataset
dataset <- generate_dataset(type="poly", num_genes=500, num_samples=200, num_groups=4)
dist <- correlation_distance(dataset$expression)
space <- reduce_dimensionality(dist, ndim=2)
filt <- outlier_filter(dist)
# plot points using their outlierness value as size and whether or not they were outliers as colours
plot(space, col=filt+2, cex=outlierness(dist)+1, pch=20)
# plot the score at each iteration of the removal process
likelihood_df <- attr(filt, "loglikelihood")
plot(likelihood_df$amount_removed, likelihood_df$log_likelihood, type="l")
}
}
\seealso{
\code{\link{correlation_distance}}, \code{\link{euclidean_distance}}, \code{\link{outlierness}}
}
