% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{outlierness}
\alias{outlierness}
\title{Outlierness}
\usage{
outlierness(dist, k=10)
}
\arguments{
\item{dist}{A numeric matrix, data frame or "\code{dist}" object.}

\item{k}{The maximum number of nearest neighbours to search.}
}
\value{
The outlierness values for each of the samples.
}
\description{
\code{outlierness} calculates the mean distance of each sample to its \emph{k} nearest neighbours.
}
\examples{
## Generate example dataset
x <- matrix(rnorm(100*2, mean=0, sd=1), ncol=2)
dist <- dist(x)
outl <- outlierness(dist, 10)

## Visualise the outlierness scores for each of the points
plot(x, cex=outl, pch=20)
}
