\name{pvalue.random}

\alias{pvalue.random}

\title{P-value using the Monte Carlo procedure}

\description{The P-value corresponding to the observed value of the test statistic is obtained by locating this value in the randomization distribution generated by a random sample of all assignment possibilities (the nonexhaustive randomization distribution).}

\usage{pvalue.random(design, statistic, save = "no", 
number, limit, data = read.table(file.choose(new = FALSE)), 
starts = file.choose(new = FALSE), assignments = file.choose(new = FALSE))}

\arguments{
  \item{design}{Type of single-case design: \code{"AB"}, \code{"ABA"}, \code{"ABAB"}, \code{"CRD"} (completely randomized design), \code{"RBD"} (randomized block design), \code{"ATD"} (alternating treatments design), \code{"MBD"} (multiple-baseline AB design) or \code{"Custom"} (user specified design).}

  \item{statistic}{Test statistic. For alternation designs, multiple-baseline designs and AB phase designs, there are 3 built-in possibilities: \code{"A-B"}, \code{"B-A"}, and \code{"|A-B|"}, which stand for the (absolute value of the) difference between condition means. 
For phase designs with more than 2 phases, 6 more built-in options are available: \code{"PA-PB"}, \code{"PB-PA"}, and \code{"|PA-PB|"} refer to the (absolute value of the) difference between the means of phase means, and \code{"AA-BB"}, \code{"BB-AA"} and \code{"|AA-BB|"} represent the (absolute value of the) difference between the sums of phase means.
Additionally, it is possible to specify a custom test statistic using the variable identifiers \code{"A"} and \code{"B"} (or in the case of phase deisgns with more than 2 phases, \code{"A1"}, \code{"B1"}, \code{"A2"}, \code{"B2"}, \code{"A"} and \code{"B"}) and any of the basic R functions. For example, \code{"abs(mean(A) - mean(B))"} can be used as a test statistic and it will be the same as using \code{"|A-B|"}.}

  \item{save}{Save the randomization distribution to a file (\code{save="yes"}) or just see it as output in the R console (default: \code{save="no"}).}

  \item{number}{Number of randomizations required.}

  \item{limit}{For phase designs: minimum number of observations per phase. 
For alternating treatments designs: maximum number of consecutive administrations of the same condition.}

  \item{data}{File in which the data can be found. Default: a window pops up in which the file can be selected.}

  \item{starts}{Only for multiple baseline designs: location of the file where the possible start points can be found. Default: a window pops up in which the file can be selected.}
  
  \item{assignments}{Only for user specified designs: location of the file where all the possible assignments can be found. Default: a window pops up in which the file can be selected.}

}

\details{

When using the default \code{data} argument, a window will pop up to ask in what file the data can be found. This text file containing the data should consist of two columns for single-case phase and alternation designs: the first with the condition labels and the second with the obtained scores.
For multiple-baseline designs it should consist of these two columns for EACH unit. This way, each row represents one measurement occasion. It is important not to label the rows or columns.

For multiple baseline designs, when using the default \code{starts} argument, second a window pops up in which is asked in what file the possible start points can be found. In this startpoint file, each row should contain all possibilities for one unit, separated by a tab. The rows and columns should not be labeled.

For user specified designs, when using the default \code{assignments} argument, second a window pops up in which is asked in what file all the possible assignments can be found. In this file, each row should contain the sequence of conditions in one possible assignment, separated by a tab. There should be one row for every possible assignment. The rows and columns should not be labeled.

When choosing to save the randomization distribution to a file, next a window will pop up (for multiple baseline designs or user specified designs this is the third pop-up window, for all other designs it is the second window) to ask where to save it. This location can be an existing file, as well as a new file that can be created by giving a file name and the extension .txt. In this latter case a confirmation is required ("The file does not exist yet. Create the file?"). 

}

\references{

Bulte, I., & Onghena, P. (2008). An R package for single-case randomization tests. Behavior Research Methods, 40, 467-478.

Bulte, I., & Onghena, P. (2009). Randomization tests for multiple baseline designs: An extension of the SCRT-R package. Behavior Research Methods, 41, 477-485.

\url{http://ppw.kuleuven.be/home/english/research/mesrg}

}

\seealso{

\code{\link{distribution.random}} to generate the corresponding nonexhaustive randomization distribution.

\code{\link{observed}} to calculate the observed test statistic.

\code{\link{distribution.systematic}} to generate the exhaustive randomization distribution and 
\code{\link{pvalue.systematic}} to obtain the corresponding p-value.

}

\examples{
data(ABAB)
pvalue.random(design = "ABAB", statistic = "AA-BB", save = "no", 
number = 100, limit = 4, data = ABAB)
}

\keyword{Single-case design}
\keyword{Randomization test}
\keyword{P-value}

