% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupfilter_time.R
\name{dupfilter_time}
\alias{dupfilter_time}
\title{Filter temporal duplicates}
\usage{
dupfilter_time(sdata, step.time = 0)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
See the data \code{\link{turtle}} for an example.
The function filters the input data by a unique "id" (e.g. transmitter number, identifier for each animal). 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} 
or \code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"lat" and "lon" are the latitude and longitude of each location in decimal degrees. 
"qi" is the quality index associated with each location fix. 
The input values can be either the number of GPS satellites or Argos Location Classes. 
Argos Location Classes will be converted to numerical values, where "A", "B", "Z" will be replaced with "-1", "-2", "-3" respectively.
The greater number indicates a higher accuracy.}

\item{step.time}{Consecutive locations less than or equal to \emph{step.time} apart are considered temporal duplicates.
Default is 0 hours.}
}
\value{
The input data frame is returned with temporal duplicates removed.
}
\description{
Function to filter temporal duplicates that are associated with the same quality index.
}
\details{
This is a partial component of \code{\link{dupfilter}}, although works as a stand-alone function.
First it identifies temporal duplicates by searching for consecutive locations that were obtained within \emph{step.time}.
For each group of temporal duplicates, the function then retains a single fix that is nearest from a previous and to a subsequent location.
}
\references{
Shimada T, Limpus C, Jones R, Hazel J, Groom R, Hamann M (2016) 
Sea turtles return home after intentional displacement from coastal foraging areas. 
\emph{Marine Biology} 163:1-14 doi:\href{http://doi.org/10.1007/s00227-015-2771-0}{10.1007/s00227-015-2771-0}
}
\seealso{
\code{\link{dupfilter}}, \code{\link{dupfilter_exact}}, \code{\link{dupfilter_qi}}, \code{\link{dupfilter_space}}, \code{\link{track_param}}
}
\author{
Takahiro Shimada
}
