% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delim_area.R
\name{delim.area}
\alias{delim.area}
\title{RasterStack preparation for modelling}
\usage{
delim.area(predictors, longmin, longmax, latmin, latmax, interval=NULL,
           crslayer = raster::crs(predictors))
}
\arguments{
\item{predictors}{RasterStack object that contains the environmental predictors used for species distribution models}

\item{longmin}{Expected minimum longitude of the RasterStack}

\item{longmax}{Expected maximum longitude of the RasterStack}

\item{latmin}{Expected minimum latitude of the RasterStack}

\item{latmax}{Expected maximum latitude of the RasterStack}

\item{interval}{Vector of 2. Minimum and maximum values outside of which the pixel values of the RasterStack first layer will be assigned to NA values. Set as NULL by default (no treatment).}

\item{crslayer}{CRS object or character string describing a projection and datum. The crs of the original RasterStack is set by default}
}
\value{
RasterLayer object
}
\description{
Delimit the RasterStack of environmental descriptors at a precise extent (latitude, longitude, maximum depth...) before computing species distribution modelling
}
\details{
\emph{interval} enable the user to delimit the RasterStack according to an interval of values applied on the \strong{first layer} of the RasterStack. It is often applied on depth in SDM studies.

Missing values contained in the provided RasterStack must be set up as NA values.
}
\examples{
data('predictors2005_2012')
envi <- predictors2005_2012

r <- SDMPlay:::delim.area(predictors = envi,
longmin = 70,longmax = 75, latmin = -50,latmax = -40,interval = c(0,-1000))
r

library(grDevices) # plot the result with nice colors
palet.col <- colorRampPalette(c('deepskyblue','green','yellow', 'red'))(80)
raster::plot(r, col=palet.col)
}
\seealso{
\link[raster]{stack}, \link[raster]{raster}, \link[raster]{origin}, \link[raster]{extent}
}

