% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tss.R
\name{tss}
\alias{tss}
\title{True Skill Statistics}
\usage{
tss(model, test = NULL)
}
\arguments{
\item{model}{\code{\linkS4class{SDMmodel}} or \code{\linkS4class{SDMmodelCV}}
object.}

\item{test}{\code{\linkS4class{SWD}} test locations for
\code{\linkS4class{SDMmodel}} objects or logical for
\code{\linkS4class{SDMmodelCV}} objects, if not provided it computes the
training AUC, default is \code{NULL}.}
}
\value{
The value of the TSS of the given model.
}
\description{
Compute the max TSS of a given model.
}
\details{
If the model is a \code{\linkS4class{SDMmodelCV}} object, the
function computes the mean of the training or testing TSS values of the
different replicates.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data, test = 0.2, only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet", data = train, fc = "l")

# Compute the training TSS
tss(model)

# Compute the testing TSS
tss(model, test)

\donttest{
# Same example but using cross validation instead of training and testing
# datasets
# Create 4 random folds splitting only the presence locations
folds = randomFolds(data, k = 4, only_presence = TRUE)
model <- train(method = "Maxnet", p = presence, a = bg, fc = "l",
               folds = folds)

# Compute the training TSS
TSS(model)

# Compute the testing TSS
TSS(model, test = TRUE)
}
}
\references{
Allouche O., Tsoar A., Kadmon R., (2006). Assessing the accuracy of species
distribution models: prevalence, kappa and the true skill statistic (TSS).
Journal of Applied Ecology, 43(6), 1223–1232.
}
\author{
Sergio Vignali
}
