% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semCluster.R
\name{extendGraph}
\alias{extendGraph}
\title{Interactome-assisted graph extension}
\usage{
extendGraph(g = list(), data, gnet, verbose = FALSE, ...)
}
\arguments{
\item{g}{A list of two graphs as igraph objects.}

\item{data}{A matrix with rows corresponding to subjects, and columns
to graph nodes.}

\item{gnet}{External interaction network as an igraph object. Interaction
data from this network will be used to integrate additional interaction
information inside the graph.}

\item{verbose}{A logical value. If FALSE (default), the processed graphs
will not be plotted to screen, saving execution time (they will be
returned anyway).}

\item{...}{Currently ignored.}
}
\value{
A list of 2 objects:
\enumerate{
\item "Ug", the extended graph (union of the input graph and guv);
\item "guv", the directed subgraph added to the input graph.
}
}
\description{
Extend an input directed graph, importing new interactions
from a second graph. Added interactions will be chosen among those
available in a given reference interactome.
}
\details{
This function takes two input graphs: the first is the input
causal model (i.e., a directed graph), and the second can be either
a directed or undirected graph, providing a set of connections to be
checked against the reference network and imported to the first graph.
Typically, the second graph is the output of either
\code{\link[SEMgraph]{SEMdag}} or \code{\link[SEMgraph]{SEMbap}}.
In the former we use the new inferred causal structure stored in the
\code{dag.red} object. In the latter, we use the new inferred covariance
structure stored in the \code{guu} object. In both cases, new hidden
directed paths and new nodes (i.e., new mediators) can be revealed.
}
\examples{

\donttest{

# Extract the "Type II diabetes mellitus" pathway:

g <- kegg.pathways[["Type II diabetes mellitus"]]
G <- properties(g)[[1]]; summary(G)

# Extend a graph using new inferred DAG edges:

library(huge)
als.npn <- huge.npn(alsData$exprs)

dag <- SEMdag(graph = G, data = als.npn, beta = 0.1)
gplot(dag$dag)
ext <- extendGraph(list(dag$dag, dag$dag.red), data = als.npn, gnet = kegg)
gplot(ext$Ug) 

# Extend a graph using the inferred bow-free path diagram:

bap <- SEMbap(graph = G, data = als.npn, gnet = kegg, d = 1, alpha = 0.1)
ext <- extendGraph(list(bap$bap, bap$guu), data = als.npn, gnet = kegg)
gplot(ext$Ug)

# Create a graph from correlation matrix, using KEGG as reference:

v <- which(colnames(als.npn) \%in\% V(G)$name)
selectedData <- als.npn[, v]
G0 <- make_empty_graph(n = ncol(selectedData))
V(G0)$name <- colnames(selectedData)

G1 <- corr2graph(R = cor(selectedData), n = nrow(selectedData),
                 type = "tmfg")
ext <- extendGraph(list(G0, G1), data = selectedData, gnet = kegg)

#Graphs
old.par <- par(no.readonly = TRUE)
par(mfrow=c(1,2), mar=rep(1,4))
plot(G1, layout = layout.circle)
plot(ext$Ug, layout = layout.circle)
par(old.par)

}

}
\references{
Palluzzi F, Grassi M (2021). SEMgraph: An R Package for Causal Network
Analysis of High-Throughput Data with Structural Equation Models.
<arXiv:2103.08332>
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
