% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{downsize}
\alias{downsize}
\title{Reduce number of workers and remove all drones and virgin queens from
  a Colony or MultiColony object}
\usage{
downsize(x, p = NULL, use = "rand", new = FALSE, simParamBee = NULL, ...)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}

\item{p}{numeric, proportion of workers to be removed from the colony; if
\code{NULL} then \code{\link{SimParamBee}$downsizeP} is used.
If input is \code{\link{MultiColony-class}},
the input could also be a vector of the same length as the number of colonies. If
a single value is provided, the same value will be applied to all the colonies}

\item{use}{character, all the options provided by \code{\link{selectInd}};
it guides the selection of workers that will be removed}

\item{new}{logical, should we remove all current workers and add a targeted
proportion anew (say, create winter workers)}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}

\item{...}{additional arguments passed to \code{p} when this argument is a
function}
}
\value{
\code{\link{Colony-class}} or \code{\link{MultiColony-class}} with workers reduced and
  drones/virgin queens removed
}
\description{
Level 2 function that downsizes a Colony or MultiColony object
  by removing a proportion of workers, all drones and all virgin queens.
  Usually in the autumn, such an event occurs in preparation for the winter months.
}
\examples{
founderGenomes <- quickHaplo(nInd = 4, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 100)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 3, nDrones = 12)

# Create and cross Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(colony)
apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(apiary)

# Downsize
colony <- downsize(x = colony, new = TRUE, use = "rand")
colony
apiary <- downsize(x = apiary, new = TRUE, use = "rand")
apiary[[1]]

# Downsize with different numbers
nWorkers(apiary); nDrones(apiary)
apiary <- downsize(x = apiary, p = c(0.5, 0.1), new = TRUE, use = "rand")
nWorkers(apiary); nDrones(apiary)
}
