% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getQtlHaplo}
\alias{getQtlHaplo}
\alias{getQueenQtlHaplo}
\alias{getFathersQtlHaplo}
\alias{getVirginQueensQtlHaplo}
\alias{getWorkersQtlHaplo}
\alias{getDronesQtlHaplo}
\title{Access QTL haplotypes of individuals in a caste}
\usage{
getQtlHaplo(
  x,
  caste = NULL,
  nInd = NULL,
  trait = 1,
  haplo = "all",
  chr = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

getQueenQtlHaplo(
  x,
  trait = 1,
  haplo = "all",
  chr = NULL,
  collapse = FALSE,
  simParamBee = NULL
)

getFathersQtlHaplo(
  x,
  nInd = NULL,
  trait = 1,
  haplo = "all",
  chr = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

getVirginQueensQtlHaplo(
  x,
  nInd = NULL,
  trait = 1,
  haplo = "all",
  chr = NULL,
  collapse = FALSE,
  simParamBee = NULL
)

getWorkersQtlHaplo(
  x,
  nInd = NULL,
  trait = 1,
  haplo = "all",
  chr = NULL,
  collapse = FALSE,
  simParamBee = NULL
)

getDronesQtlHaplo(
  x,
  nInd = NULL,
  trait = 1,
  haplo = "all",
  chr = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}}, \code{\link[SIMplyBee]{Colony-class}}, or
\code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link[AlphaSimR]{Pop-class}},
and character when \code{x} is a \code{\link[SIMplyBee]{Colony-class}} or
 \code{\link[SIMplyBee]{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, number of individuals to access, if \code{NULL} all
individuals are accessed, otherwise a random sample}

\item{trait}{numeric (trait position) or character (trait name), indicates
which trait's QTL haplotypes to retrieve}

\item{haplo}{character, either "all" for all haplotypes or an integer for a
single set of haplotypes, use a value of 1 for female haplotypes and a
value of 2 for male haplotypes}

\item{chr}{numeric, chromosomes to retrieve, if \code{NULL}, all chromosome
are retrieved}

\item{dronesHaploid}{logical, return haploid result for drones?}

\item{collapse}{logical, if the return value should be a single matrix
with haplotypes of all the individuals}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
matrix with haplotypes when \code{x} is \code{\link[SIMplyBee]{Colony-class}}
  and list of matrices with haplotypes when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}, named by colony id when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 0 function that returns QTL haplotypes of individuals in a
  caste.
}
\section{Functions}{
\itemize{
\item \code{getQueenQtlHaplo()}: Access QTL haplotype data of the queen

\item \code{getFathersQtlHaplo()}: Access QTL haplotype data of fathers

\item \code{getVirginQueensQtlHaplo()}: Access QTL haplotype data of virgin queens

\item \code{getWorkersQtlHaplo()}: Access QTL haplotype of workers

\item \code{getDronesQtlHaplo()}: Access QTL haplotype data of drones

}}
\examples{
founderGenomes <- quickHaplo(nInd = 4, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(nQtlPerChr = 10)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 200)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(x = colony, nInd = 5)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)
apiary <- addVirginQueens(x = apiary, nInd = 5)

# Input is a population
getQtlHaplo(x = getQueen(colony))
queens <- getQueen(apiary, collapse = TRUE)
getQtlHaplo(queens)

# Input is a Colony
getQtlHaplo(colony, caste = "queen")
getQueenQtlHaplo(colony)

getQtlHaplo(colony, caste = "workers", nInd = 3)
getWorkersQtlHaplo(colony)
# Same aliases exist for all the castes!

# Get haplotypes for all individuals
getQtlHaplo(colony, caste = "all")
# Get all haplotypes in a single matrix
getQtlHaplo(colony, caste = "all", collapse = TRUE)

# Input is a MultiColony - same behaviour as for the Colony
getQtlHaplo(apiary, caste = "queen")
getQueenQtlHaplo(apiary)

# Get the haplotypes of all individuals either by colony or in a single matrix
getQtlHaplo(apiary, caste = "all")
getQtlHaplo(apiary, caste = "all", collapse = TRUE)

}
\seealso{
\code{\link[SIMplyBee]{getQtlHaplo}} and \code{\link[AlphaSimR]{pullQtlHaplo}} as well as
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
