% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParamBee.R
\name{splitPUnif}
\alias{splitPUnif}
\alias{splitPColonyStrength}
\title{Sample the split proportion - proportion of removed workers in a
  managed split}
\usage{
splitPUnif(colony, n = 1, min = 0.2, max = 0.4)

splitPColonyStrength(colony, n = 1, nWorkersFull = 100, scale = 1)
}
\arguments{
\item{colony}{\code{\link[SIMplyBee]{Colony-class}}}

\item{n}{integer, number of samples}

\item{min}{numeric, lower limit for \code{splitPUnif}}

\item{max}{numeric, upper limit for \code{splitPUnif}}

\item{nWorkersFull}{numeric, average number of workers in a full/strong
colony for \code{splitPColonyStrength} (actual number can go beyond this
value)}

\item{scale}{numeric, scaling of numbers in \code{splitPColonyStrength}
to avoid to narrow range when colonies have a large number of bees (in that
case change \code{nWorkersFull} too!)}
}
\value{
numeric, split proportion
}
\description{
Sample the split proportion - proportion of removed workers in a
  managed split - used when \code{p = NULL} - (see
  \code{\link[SIMplyBee]{SimParamBee}$splitP}).

  This is just an example. You can provide your own functions that satisfy
  your needs!
}
\details{
\code{splitPUnif} samples from a uniform distribution between values
  0.2 and 0.4 irrespective of colony strength.

  \code{splitPColonyStrength} samples from a beta distribution with mean
  \code{a / (a + b)}, where \code{a = nWorkers + nWorkersFull} and \code{b =
  nWorkers}. This beta sampling mimics larger splits for strong colonies and
  smaller splits for weak colonies - see examples. This is just an example -
  adapt to your needs!

  The \code{nWorkersFull} default value used in this function is geared
  towards a situation where we simulate ~100 workers per colony (down-scaled
  simulation for efficiency). If you simulate more workers, you should change
  the default accordingly.
}
\section{Functions}{
\itemize{
\item \code{splitPColonyStrength()}: Sample the split proportion - the proportion of
removed workers in a managed split based on the colony strength

}}
\examples{
splitPUnif()
splitPUnif()
p <- splitPUnif(n = 1000)
hist(p, breaks = seq(from = 0, to = 1, by = 0.01), xlim = c(0, 1))

# Example for splitPColonyStrength()
founderGenomes <- quickHaplo(nInd = 2, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 15)
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = drones)
colony <- addWorkers(colony, nInd = 10)
nWorkers(colony) # weak colony
splitPColonyStrength(colony)
splitPColonyStrength(colony)
colony <- addWorkers(colony, nInd = 100)
nWorkers(colony) # strong colony
splitPColonyStrength(colony)
splitPColonyStrength(colony)

# Logic behind splitPColonyStrength()
nWorkersFull <- 100
nWorkers <- 0:200
splitP <- 1 - rbeta(
  n = length(nWorkers),
  shape1 = nWorkers + nWorkersFull,
  shape2 = nWorkers
)
plot(splitP ~ nWorkers, ylim = c(0, 1))
abline(v = nWorkersFull)
pKeep <- 1 - splitP
plot(pKeep ~ nWorkers, ylim = c(0, 1))
abline(v = nWorkersFull)
}
\seealso{
\code{\link[SIMplyBee]{SimParamBee}} field \code{splitP}
}
