% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIR_threshold_opt.R
\name{SIR_threshold_opt}
\alias{SIR_threshold_opt}
\title{SIR optimally thresholded}
\usage{
SIR_threshold_opt(
  Y,
  X,
  H = 10,
  n_lambda = 100,
  thresholding = "hard",
  graph = TRUE,
  output = TRUE,
  choice = ""
)
}
\arguments{
\item{Y}{A numeric vector representing the dependent variable (a response vector).}

\item{X}{A matrix representing the quantitative explanatory variables (bind by column).}

\item{H}{The chosen number of slices (default is 10).}

\item{n_lambda}{The number of lambda to test. The n_lambda tested lambdas are
uniformally distributed between 0 and the maximum value of the interest matrix. (default is 100).}

\item{thresholding}{The thresholding method to choose between hard and soft (default is hard).}

\item{graph}{A boolean, set to TRUE to plot graphs (default is TRUE).}

\item{output}{A boolean, set to TRUE to print informations (default is TRUE).}

\item{choice}{the graph to plot:
\itemize{
\item "estim_ind" Plot the estimated index by the SIR model versus Y.
\item "opt_lambda" Plot the choice of the optimal lambda.
\item "cos2_selec" Plot the evolution of cos^2 and variable selection according to
lambda.
\item "regul_path" Plot the regularization path of b.
\item "" Plot every graphs (default).
}}
}
\value{
An object of class SIR_threshold_opt, with attributes:
\item{b}{This is the optimal estimated EDR direction, which is the principal
eigenvector of the interest matrix.}
\item{lambdas}{A vector that contains the tested lambdas.}
\item{lambda_opt}{The optimal lambda.}
\item{mat_b}{A matrix of size p*n_lambda that contains an estimation of beta
in the columns for each lambda.}
\item{n_lambda}{The number of lambda tested.}
\item{vect_nb_zeros}{The number of 0 in b for each lambda.}
\item{list_relevant_variables}{A list that contains the variables selected by
the model.}
\item{fit_bp}{An object of class breakpoints from the strucchange package,
that contains informations about the breakpoint which allows to deduce the
optimal lambda.}
\item{indices_useless_var}{A vector that contains p items: each variable is
associated with the number of lambda that selects this variable.}
\item{vect_cos_squared}{A vector that contains for each lambda,
the cosine squared between vanilla SIR and SIR thresholded.}
\item{Y}{The response vector.}
\item{n}{Sample size.}
\item{p}{The number of variables in X.}
\item{H}{The chosen number of slices.}
\item{M1}{The interest matrix thresholded with the optimal lambda.}
\item{thresholding}{The thresholding method used.}
\item{call}{Unevaluated call to the function.}
\item{X_reduced}{The X data restricted to the variables selected by the model.
It can be used to estimate a new SIR model on the relevant variables to improve
the estimation of b.}
\item{index_pred}{The index Xb' estimated by SIR.}
}
\description{
Apply a single-index \eqn{SIR} on \eqn{(X,Y)} with \eqn{H} slices, with a soft/hard thresholding
of the interest matrix \eqn{\widehat{\Sigma}_n^{-1}\widehat{\Gamma}_n} by an optimal
parameter \eqn{\lambda_{opt}}. The \eqn{\lambda_{opt}} is found automatically among a vector
of \code{n_lambda} \eqn{\lambda}, starting from 0 to the maximum value of
\eqn{\widehat{\Sigma}_n^{-1}\widehat{\Gamma}_n}. For each feature of \eqn{X},
the number of \eqn{\lambda} associated with a selection of this feature is stored
(in a vector of size \eqn{p}). This vector is sorted in a decreasing way. Then, thanks to
\code{strucchange::breakpoints}, a breakpoint is found in this sorted vector. The coefficients
of the variables at the left of the breakpoint, tend to be automatically toggled to 0 due
to the thresholding operation based on \eqn{\lambda_{opt}}, and so should be removed (useless
variables). Finally, \eqn{\lambda_{opt}} corresponds to the first \eqn{\lambda} such that the
associated \eqn{\hat{b}} provides the same number of zeros as the breakpoint's value.

For example, for \eqn{X \in R^{10}} and \code{n_lambda=100}, this sorted vector can look like this :\tabular{llllllllll}{
   X10 \tab X3 \tab X8 \tab X5 \tab X7 \tab X9 \tab X4 \tab X6 \tab X2 \tab X1 \cr
   2 \tab 3 \tab 3 \tab 4 \tab 4 \tab 4 \tab 6 \tab 10 \tab 95 \tab 100 \cr
}


Here, the breakpoint would be 8.
}
\examples{
# Generate Data
set.seed(2)
n <- 200
beta <- c(1,1,rep(0,8))
X <- mvtnorm::rmvnorm(n,sigma=diag(1,10))
eps <- rnorm(n)
Y <- (X\%*\%beta)**3+eps

# Apply SIR with soft thresholding
SIR_threshold_opt(Y,X,H=10,n_lambda=300,thresholding="soft")
}
