% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SIR_bootstrap.R
\name{plot.SIR_bootstrap}
\alias{plot.SIR_bootstrap}
\title{Graphical output of SIR_bootstrap}
\usage{
\method{plot}{SIR_bootstrap}(x, choice = "", ...)
}
\arguments{
\item{x}{A SIR_bootstrap object}

\item{choice}{the graph to plot: 
\itemize{
  \item "eigvals" Plot the eigen values of the matrix of interest.
  \item "estim_ind" Plot the estimated index by the SIR model versus Y.
  \item "" Plot every graphs (default).
}}

\item{\ldots}{arguments to be passed to methods, such as graphical parameters (not used here).}
}
\value{
No return value
}
\description{
Display the 10 first eigen values and the estimated index versus Y of the 
SIRbootstrap model.
}
\examples{
# Generate Data
set.seed(10)
n <- 500
beta <- c(1,1,rep(0,8))
X <- mvtnorm::rmvnorm(n,sigma=diag(1,10))
eps <- rnorm(n)
Y <- (X\%*\%beta)**3+eps

# Apply bootstrap SIR
res = SIR_bootstrap(Y, X, H = 10, B = 10)

# Eigen values
plot(res,choice="eigvals")

# Estimated index versus Y
plot(res,choice="estim_ind")
}
