% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanagement.R
\name{normalize_data}
\alias{normalize_data}
\title{normalize_data: Normalize data to the range [0, 1]}
\usage{
normalize_data(
  data,
  predictorNames,
  responseName,
  predictorsUpper = NULL,
  predictorsLower = NULL,
  responseRange = NULL
)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{predictorNames}{A character vector of covariate column names.}

\item{responseName}{A character string specifying the response variable name.}

\item{predictorsUpper}{Optional numeric vector of upper bounds for covariates.}

\item{predictorsLower}{Optional numeric vector of lower bounds for covariates.}

\item{responseRange}{Optional numeric vector of length 2 giving lower and upper bounds for the response.}
}
\value{
A normalized data frame with the same column structure as \code{data}, with values scaled to \eqn{[0,1]}.
}
\description{
Scales the response and covariates of a dataset to the unit interval \eqn{[0,1]}.
This normalization is required before applying SLGP methods. If range bounds are
not provided, they are computed from the data.
}
\keyword{internal}
