% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotCoocMutex}
\alias{plotCoocMutex}
\title{plotCoocMutex}
\usage{
plotCoocMutex(maffile, mutcell.summary, cellnumcuoff = 3, fontSize = 0.8)
}
\arguments{
\item{maffile}{The name of mutation annotation file (MAF) format data. It must be an absolute path or the name  relatived to the current working directory.}

\item{mutcell.summary}{The result of `mutcellsummary` function}

\item{cellnumcuoff}{A threshold value (4 as the default value). The mutation genes which drive at least "cellnumcuoff" cells are retained for drawing a co-occurrence and mutual exclusivity plots.}

\item{fontSize}{cex for gene names. Default 0.8}
}
\description{
Function `plotCoocMutex` plots the co-occurrence and mutual exclusivity plots for mutation genes which drive immune cells.
}
\examples{
# get the result of `exp2cell` funtion
cellmatrix<-GetExampleData("cellmatrix")

#get the binary mutations matrix,
mutmatrix<-GetExampleData("mutmatrix")

# get the result of `mutcorcell` funtion
mutcell<-GetExampleData("mutcell")

#perform the function mutcellsummary
summary<-mutcellsummary(mutcell = mutcell,mutmatrix = mutmatrix,cellmatrix=cellmatrix)

#dir is the name of mutation annotation file (MAF) format data.
#It must be an absolute path or the name relatived to the current working directory.
maf<-"dir"
#plot the co-occurrence and mutual exclusivity plots for mutation genes which drive immune cells.
\donttest{plotCoocMutex(maffile = maf,mutcell.summary = summary,cellnumcuoff =0)}
}
\references{
Gerstung M, Pellagatti A, Malcovati L, et al. Combining gene mutation with gene expression data improves outcome prediction in myelodysplastic syndromes. Nature Communications. 2015;6:5901. doi:10.1038/ncomms6901.
}
