% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotwaterfall}
\alias{plotwaterfall}
\title{plotwaterfall}
\usage{
plotwaterfall(
  maffile,
  mutcell.summary,
  cellnumcuoff = 3,
  fontSize = 0.8,
  showTumorSampleBarcodes = F,
  showTitle = TRUE,
  colors = NULL
)
}
\arguments{
\item{maffile}{The name of mutation annotation file (MAF) format data. It must be an absolute path or the name  relatived to the current working directory.}

\item{mutcell.summary}{The result of `mutcellsummary` function}

\item{cellnumcuoff}{a threshold value (3 as the default value). The mutation genes which drive at least "cellnumcuoff" cells are retained for drawing an waterfall.}

\item{fontSize}{font size for gene names. Default 0.8.}

\item{showTumorSampleBarcodes}{logical to include sample names.}

\item{showTitle}{Default TRUE}

\item{colors}{named vector of colors for each Variant_Classification.}
}
\description{
Function `plotwaterfall` plots the waterfall for mutation genes which drive immune cells.
}
\examples{
# get result of `exp2cell` funtion
cellmatrix<-GetExampleData("cellmatrix")

#get the binary mutations matrix,
mutmatrix<-GetExampleData("mutmatrix")

# get the result of `mutcorcell` funtion
mutcell<-GetExampleData("mutcell")

#perform the function mutcellsummary
summary<-mutcellsummary(mutcell = mutcell,mutmatrix = mutmatrix,cellmatrix=cellmatrix)

#dir is the name of mutation annotation file (MAF) format data.
#It must be an absolute path or the name relatived to the current working directory.
maf<-system.file("extdata", "example.maf.gz", package = "SMDIC") #MAF file
# mutcell.summary is the result of function mutcellsummary

#plot the waterfall for mutation genes which drive immune cells
\donttest{plotwaterfall(maffile = maf,mutcell.summary = summary,cellnumcuoff =3)}
}
