% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastphase.R
\name{SNPknock.fp.loadFit}
\alias{SNPknock.fp.loadFit}
\title{Load the parameter estimates obtained by fastPHASE}
\usage{
SNPknock.fp.loadFit(r_file, alpha_file, theta_file, char_file)
}
\arguments{
\item{r_file}{a string with the path of the "_rhat.txt" file produced by fastPHASE.}

\item{alpha_file}{a string with the path of the "_alphahat.txt" file produced by fastPHASE.}

\item{theta_file}{a string with the path of the "_thetahat.txt" file produced by fastPHASE.}

\item{char_file}{a string with the path of the "_origchars" file produced by fastPHASE.}
}
\value{
A structure containing the parameters from the Li and Stephens HMM for phased haplotypes.
}
\description{
This function loads the parameter estimates obtained by fastPHASE (see \link{SNPknock.fp.runFastPhase})
and assembles the Li and Stephens HMM, in the format required by the knockoff generation functions
\link{SNPknock.knockoffHaplotypes} and \link{SNPknock.knockoffGenotypes}.
}
\details{
This function returns a structure with three fields: 
\itemize{
  \item{"r": a numerical array of length p.}
  \item{"alpha": a numerical array of size (p,K).}
  \item{"theta": a numerical array of size (p,K).}
 }
}
\examples{
# Specify the location of the fastPHASE output files containing the parameter estimates.
# Example files can be found in the package installation directory.
r_file = system.file("extdata", "genotypes_rhat.txt", package = "SNPknock")
alpha_file = system.file("extdata", "genotypes_alphahat.txt", package = "SNPknock")
theta_file = system.file("extdata", "genotypes_thetahat.txt", package = "SNPknock")
char_file = system.file("extdata", "genotypes_origchars", package = "SNPknock")

# Read the parameter files and build the HMM
hmm = SNPknock.fp.loadFit(r_file, alpha_file, theta_file, char_file)

}
\references{
Scheet and Stephens,  A fast and flexible statistical model for large-scale population genotype data,
  Am J Hum Genet (2006).
  \href{http://www.sciencedirect.com/science/article/pii/S000292970763701X}{http://www.sciencedirect.com/science/article/pii/S000292970763701X}
}
\seealso{
Other fastPHASE: \code{\link{SNPknock.fp.loadFit_hmm}},
  \code{\link{SNPknock.fp.runFastPhase}},
  \code{\link{SNPknock.fp.writeX}}
}
