% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{SNSeg_estimate}
\alias{SNSeg_estimate}
\title{Parameter estimates of each segment separated by Self-Normalization (SN) based
change-point estimates}
\usage{
SNSeg_estimate(SN_result)
}
\arguments{
\item{SN_result}{An S3 object served as the output of the functions \code{SNSeg_Uni},
\code{SNSeg_Multi}, or \code{SNSeg_HD}.}
}
\value{
\code{SNSeg_estimate} returns an S3 object of class "SNSeg_estimate" including
the parameter estimates of each segment separated by the SN-based change-point
estimates.

\enumerate{
\item If the time series is univariate, for a single parameter change, the output
contains parameter estimates for one of the followings: \code{mean}, \code{variance},
\code{acf}, \code{quantile}, or \code{general}, which can be referred to the change
in a single mean, variance, autocorrelation, a given quantile level, or a general
functional. For multi-parameter changes, the output can be a combination of
\code{mean}, \code{variance}, \code{acf}, and a dataframe with each quantile level
depending on the type of parameters (argument \code{paras_to_test} of \code{SNSeg_Uni},
\code{SNSeg_Multi}, or \code{SNSeg_HD}) that users select.

\item If the time series is multivariate with a dimension no greater than 10, the output
contains parameter estimates for one of the followings: \code{bivcor}, \code{multi_mean},
or \code{covariance}, which can be referred to the change in correlation between
bivariate time series and the change in multivariate means or covariance between
multivariate time series.

\item If the time series is high-dimensional with a dimension greater than 10, the output
contains the parameter estimate \code{HD_mean} to represent the change in high-dimensional
means.
}

For more examples of \code{SNSeg_estimate} see the help vignette:
\code{vignette("SNSeg", package = "SNSeg")}
}
\description{
The function \code{SNSeg_estimate} computes parameter estimates of each segment
that are separated by the SN-based change-point estimates.
}
\examples{
\donttest{
# code to simulate a univariate time series
set.seed(7)
ts <- MAR_Variance(2, "V1")
ts <- ts[,2]
# test the change in a single parameter (variance)
# grid_size defined
result <- SNSeg_Uni(ts, paras_to_test = "variance", confidence = 0.9,
                    grid_size_scale = 0.05, grid_size = 67,
                    plot_SN = TRUE, est_cp_loc = TRUE)
# estimated change-point locations
result$est_cp
# variance estimates of the separated segments
SNSeg_estimate(SN_result = result)

# For more examples of SNSeg_estimate, please run
# the command: vignette("SNSeg", package = "SNSeg")
}

}
