% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasTransferLearning.R
\name{evalKerasTransferLearning}
\alias{evalKerasTransferLearning}
\title{evalKerasTransferLearning}
\usage{
evalKerasTransferLearning(x, kerasConf = getKerasConf(), data = NULL)
}
\arguments{
\item{x}{matrix of hyperparameter values to evaluate with the function.
Rows for points and columns for dimension.
\code{"dropout" =  x[1]},
\code{"learning_rate" =  x[2]},
\code{"epochs" = x[3]},
\code{"beta_1" =  x[4]},
\code{"beta_2" =  x[5]},
\code{"epsilon" = x[6]}, and
\code{"optimizer" = x[7]} (type: factor).}

\item{kerasConf}{List of additional parameters passed to keras as described in \code{\link{getKerasConf}}.
Default: \code{kerasConf = getKerasConf()}.}

\item{data}{data}
}
\value{
list with function values (training, validation, and test loss/accuracy,
and keras model information)
}
\description{
Hyperparameter Tuning: Keras TransferLearning Test Function.
}
\details{
Trains a transfer learning model.
Standard Code from https://keras.rstudio.com/
Modified by T. Bartz-Beielstein (tbb@bartzundbartz.de)
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE = FALSE
if(PYTHON_RETICULATE){

library("SPOTMisc")
lower <- c(1e-6, 1e-6, 1, 0.6, 0.99, 1e-9, 1)
x <- matrix(lower, 1,)
res <- evalKerasTransferLearning(x,
                                 kerasConf = getKerasConf()
                                 )
str(res)
### The number of units for all layers can be listed as follows:
res$modelConf$config$layers[,2]$units
}
}
}
\seealso{
\code{\link{getKerasConf}}

\code{\link{funKerasTransferLearning}}

\code{\link{funKerasMnist}}

\code{\link[keras]{fit}}
}
