% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\name{applyPeaksFilter,msi.dataset-method}
\alias{applyPeaksFilter,msi.dataset-method}
\alias{applyPeaksFilter-msi.dataset-method}
\alias{applyPeaksFilter}
\title{Apply the results of a peaks filter.}
\usage{
\S4method{applyPeaksFilter}{msi.dataset}(object, peakFilter)
}
\arguments{
\item{object}{\link{msi.dataset-class} object.}

\item{peakFilter}{peaks filter results.}
}
\value{
\link{msi.dataset-class} object with only selected peaks.
}
\description{
\code{applyPeaksFilter} select the peaks returned by a peak filter. Custom
filters can be created passing a named array of selected peak indices to
\link{createPeaksFilter}. Names correspond to the m/z values of the selected
peaks and must coincide with those of the MS dataset.
}
\examples{
## Load package
library("SPUTNIK")

## Mass spectrometry intensity matrix
X <- matrix(rnorm(16000), 400, 40)
X[X < 0] <- 0

## Print original dimensions
print(dim(X))

## m/z vector
mzVector <- seq(600, 900, by = (900 - 600) / 39)

## Read the image size
imSize <- c(20, 20)

## Construct the ms.dataset object
msiX <- msiDataset(X, mzVector, imSize[1], imSize[2])

## Calculate the p-values using the Clark Evans test, then apply Benjamini-
## Hochberg correction.
csr <- CSRPeaksFilter(
  msiData = msiX, method = "ClarkEvans",
  calculateCovariate = FALSE, adjMethod = "BH"
)

## Print selected peaks
print(csr$q.value)

## Create a new filter selecting corrected p-values < 0.001
selIdx <- which(csr$q.value < 0.001)
csrFilter <- createPeaksFilter(selIdx)
}
