% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterAccess.R
\docType{data}
\name{WaterAccess}
\alias{WaterAccess}
\title{Water access}
\format{
A data frame with 150 rows (15 participants by 10 reps each) 
and 12 columns:
\describe{
  \item{Region}{The region; one of \code{Mbeng}, \code{Mbih} or 
        \code{Ntsingbeu}}
  \item{Age}{The age of the woman in the household, in years}
  \item{Education}{The level of education of the woman;
        one of \code{Primary or less} or \code{Secondary or higher}}
  \item{SourceDistance}{The distance to the water source; 
        one of \code{Under 100m}, \code{100m to 1000m} or \code{Over 1000m}}
  \item{SourceQueueTime}{The queuing time at the water source; 
        one of \code{Under 5 min}, \code{5 to 15 min} or \code{Over 15 min}}
  \item{HasGarden}{Whether the household has a farming garden; 
        one of \code{Y} or \code{N}}
  \item{HasLivestock}{Whether the household keeps livestock; 
        one of \code{Y} or \code{N}}
  \item{HouseholdPeople}{The number of people in the household}
  \item{HouseholdUnder5s}{The number of people under 5 in the household}
  \item{WaterSource}{The water source; 
        one of \code{Tap}, \code{Bore}, \code{Well} or \code{River}}
  \item{WashContainer}{How often the water container is washed; 
        one of \code{Before each fill}, \code{Once per week} 
        or \code{Once per month}}
  \item{Diarrhea}{Whether a child has had diarrhoea in the last two weeks; 
        one of \code{Y} or \code{N}}
}
}
\source{
Nounkeu, C. D., Metapi, Y. D., Ouabo, F. K., Kamguem, A. S. T., Nono, B., 
Azza, N., Leumeni, P., Nguefack-{T}sague, G., Todem, D., 
Dharod, J. M., & Kuate, D. (2022). 
"Assessment of drinking water access and household water insecurity: 
A cross sectional study in three rural communities of the 
Menoua division, West Cameroon". 
\emph{PLOS Water}, \bold{1}(8), e0000029.
}
\usage{
data(WaterAccess)
}
\description{
Water access for households in West Cameroon.
}
\keyword{datasets}
