% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covmatrix.R
\name{covmatrix.SSN2}
\alias{covmatrix.SSN2}
\alias{covmatrix.ssn_lm}
\alias{covmatrix.ssn_glm}
\title{Create a covariance matrix}
\usage{
\method{covmatrix}{ssn_lm}(object, newdata, cov_type, ...)

\method{covmatrix}{ssn_glm}(object, newdata, cov_type, ...)
}
\arguments{
\item{object}{A fitted model object (e.g., \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}).}

\item{newdata}{If omitted, the covariance matrix of
the observed data is returned. If provided, \code{newdata} is
a data frame or \code{sf} object that contains coordinate information
required to construct the covariance between \code{newdata} and
the observed data. If a data frame, \code{newdata}
must contain variables that represent coordinates having the same name as
the coordinates from the observed data used to fit \code{object}. If an
\code{sf} object, coordinates are obtained from the geometry of \code{newdata}.}

\item{cov_type}{The type of covariance matrix returned. If \code{newdata}
is omitted, the \eqn{n \times n} covariance matrix of the observed
data is returned, where \eqn{n} is the sample size used to fit \code{object}.
If \code{newdata} is provided and \code{cov_type} is \code{"pred.obs"} (the default),
the \eqn{m \times n} covariance matrix of the predicted and observed data is returned,
where \eqn{m} is the number of observations in the prediction data.
If \code{newdata} is provided and \code{cov_type} is \code{"obs.pred"},
the \eqn{n \times m} covariance matrix of the observed and prediction data is returned.
If \code{newdata} is provided and \code{cov_type} is \code{"pred.pred"},
the \eqn{m \times m} covariance matrix of the prediction data is returned.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A covariance matrix (see \code{cov_type}).
}
\description{
Create a covariance matrix from a fitted model object.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, predpts = "CapeHorn", overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
covmatrix(ssn_mod)
covmatrix(ssn_mod, "CapeHorn")
}
