% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssn_get_netgeom.R
\name{ssn_get_netgeom}
\alias{ssn_get_netgeom}
\title{Extract netgeom column}
\usage{
ssn_get_netgeom(x, netvars = "all", reformat = FALSE)
}
\arguments{
\item{x}{An sf data.frame found in an \code{SSN} object or the
netgeom column as a vector}

\item{netvars}{Network coordinate variables to return. Default is
"all". For edges, valid column names include: "NetworkID",
"SegmentID", and "DistanceUpstream". For point datasets, valid column
names include "NetworkID", "SegmentID", "DistanceUpstream", "ratio", "pid",
and "locID".}

\item{reformat}{Convert network coordinate variables from character to numeric.}
}
\value{
If more than one column is requested using netvars, the
function returns a data.frame (default). If only one column is
requested, the result is a vector.
}
\description{
Extract topological information from netgeom column
}
\details{
When an \code{SSN} object is generated using the
\code{importSSN} function, a text column named "netgeom" is added
to the edges, observed sites, and prediction sites (if they
exist) data.frames. The netgeom column contains data used to
describe how edge and site features relate to one another in
topological space. For edges, netgeom values contain the
"ENETWORK" prefix, with 3 space delimited values in parentheses:
"ENETWORK (NetworkID SegmentID DistanceUpstream)". For point
datasets (observed and prediction sites), the values contain the
"SNETWORK" prefix, followed by 6 space delimited values in parentheses:
"SNETWORK (NetworkID SegmentID DistanceUpstream ratio pid locID)". The
\code{ssn_get_netgeom} function extracts and converts these
values from text to numeric, returning either a data.frame
(default) or vector containing the variables requested via
\code{netvars}.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_get_netgeom(mf04p$obs)
ssn_get_netgeom(mf04p$edges, "DistanceUpstream")
}
