% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_organize.R
\name{rem_reps}
\alias{rem_reps}
\alias{rem_reps.swmpr}
\title{Remove replicates in nutrient data}
\usage{
rem_reps(swmpr_in, ...)

\method{rem_reps}{swmpr}(swmpr_in, FUN = function(x) mean(x, na.rm = TRUE),
  ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{arguments passed to other methods}

\item{FUN}{function to combine values, defaults to mean}
}
\value{
Returns a swmpr object for nutrient data with no replicates.
}
\description{
Remove replicates in SWMP nutrient data to keep approximate monthly time step
}
\details{
Raw nutrient data obtained from the CDMO will usually include replicate samples that are taken within a few minutes of each other.  This function combines nutrient data that occur on the same day.  The \code{datetimestamp} column will always be averaged for replicates, but the actual observations will be combined based on the user-supplied function which defauls to the mean.  Other suggested functions include the \code{\link[stats]{median}}, \code{\link[base]{min}}, or \code{\link[base]{max}}.  The entire function call including treatment of \code{NA} values should be passed to the \code{FUN} argument (see the examples).  The function is meant to be used after \code{\link{qaqc}} processing, although it works with a warning if QAQC columns are present.
}
\examples{
## get nutrient data
data(apacpnut)
swmp1 <- apacpnut

# remove replicate nutrient data
rem_reps(swmp1)

# use different function to aggregate replicates
func <- function(x) max(x, na.rm = TRUE)
rem_reps(swmp1, FUN = func)
}
\seealso{
\code{\link{qaqc}}
}
\concept{
organize

organize
}

