% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_params.R
\name{all_params}
\alias{all_params}
\title{Import current station records from the CDMO}
\usage{
all_params(station_code, Max = 100, param = NULL, trace = TRUE)
}
\arguments{
\item{station_code}{chr string of station, 7 or 8 characters}

\item{Max}{numeric value for number of records to obtain from the current date}

\item{param}{chr string for a single parameter to return, defaults to all parameters for a station type.}

\item{trace}{logical indicating if import progress is printed in console}
}
\value{
Returns a swmpr object, all available parameters including QAQC columns
}
\description{
Import current station records from the CDMO starting with the most current date
}
\details{
This function retrieves data from the CDMO through the web services URL.  The computer making the request must have a registered IP address.  Visit the CDMO web services page for more information: \url{https://cdmo.baruch.sc.edu/webservices.cfm}.  Function is the CDMO equivalent of \code{exportAllParamsXMLNew} but actually uses \code{\link{all_params_dtrng}}, which is a direct call to \code{exportAllParamsDateRangeXMLNew}.
}
\examples{

\dontrun{

## all parameters for a station, most recent
all_params('hudscwq')

}
}
\seealso{
\code{\link{all_params_dtrng}}, \code{\link{single_param}}
}
\concept{retrieve}
