\name{evalSolution}
\Rdversion{1.1}
\alias{evalSolution}
\title{
Allows to evaluate the solution produced by the function 'optimizeStrata' by
selecting a number of samples from the frame with the optimal stratification, and
calculating average CV's on the target variables Y's together with differences
between estimates and the values of the parameters in the population.
}
\description{
The user can indicate the number of samples that must be selected by the frame to which 
the optimal stratification has been applied. The allocation is the one reported in the
dataframe 'outstrata'. First, the true values of the parameters are calculated from the
frame. Then, for each sample the sampling estimates are calculated, together with the 
differences between them and the true values of the parameters.
At the end, an estimate of the CV is produced for each target variable, in order to compare them
with the precision constraints set at the beginning of the optimization process.
Boxplots of distribution of the CV's in the different domains are produced for each Y variable ('cv.pdf'),
together with boxplot of the distributions of differences between estimates and values of the parameters
in the population ('differences.pdf').

}
\usage{
evalSolution(frame,
		outstrata,
		nsampl=100)
}
\arguments{
  \item{frame}{
The frame to which the optimal stratification has been applied ('framenew')
	}
  \item{outstrata}{
The new (aggregated) strata generated by the function 'optimizeStrata'
	}
  \item{nsampl}{
The number of sample to be drawn from the frame
	}
}

\examples{
\dontrun{
library(SamplingStrata)
data(swisserrors)
data(swissstrata)
# run  optimization
outstrata <- optimizeStrata (
	errors = swisserrors,
	strata = swissstrata,
	cens = NULL,
	strcens = FALSE,
	alldomains = FALSE,
	dom = 1,
	initialStrata = nrow(swissstrata)/3,
	addStrataFactor = 0.01,
	minnumstr = 2,
	iter = 100,
	pops = 20,
	mut_chance = 0.05,
	elitism_rate = 0.2,
	highvalue = 100000000,
	suggestions = NULL,
	realAllocation = TRUE,
	writeFile = "YES")
# update sampling strata with new strata labels
newstrata <- updateStrata(swissstrata)
# update sampling frame with new strata labels
data(swissframe)
framenew <- updateFrame(frame=swissframe,newstrata=newstrata)
# evaluate the current solution
evalSolution(framenew, outstrata, 1000)
}
}
\keyword{ survey }

