% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Util_DB_MIUR_bool.R
\name{Util_DB_MIUR_bool}
\alias{Util_DB_MIUR_bool}
\title{Clean and convert the raw school buildings data to Boolean variables}
\usage{
Util_DB_MIUR_bool(
  data = NULL,
  cutout = NULL,
  col_cut_thresh = 10^3,
  verbose = TRUE,
  track_deleted = TRUE,
  ...
)
}
\arguments{
\item{data}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}. Input data obtaned through the function \code{\link{Get_DB_MIUR}}.
If \code{NULL} it will be downloaded automatically with the appropriate arguments, but not saved in the global environment. \code{NULL} by default.}

\item{cutout}{Character. The columns to cut out. If \code{NULL}, it will be determined automatically.
\code{NULL} by default.}

\item{col_cut_thresh}{Numeric. The threshold of missing values allowed for each variable.
If a variable as a higher number of missing observations, then it is cut out. \code{1000} by default.}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. TRUE by default.}

\item{track_deleted}{Logical. If \code{TRUE}, the function returns the names of the school not included in the output dataframe. \code{TRUE} by default.}
}
\value{
If \code{track_deleted == TRUE}, An object of class \code{list} including two objects:
\itemize{
  \item \code{$data}: object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, the output dataframe. All variables besides the first 8 ones (which identify the record) are numeric.
  \item \code{$deleted}: character. The school codes corresponding to deleted rows

}

If \code{track_deleted == FALSE}, the output is only the first element of the list.
}
\description{
This function cleans the output of the \code{\link{Get_DB_MIUR}} function from missing values in two steps:
\itemize{
\item First, it deletes both the columns exceeding a threshold of missing values (1000 by default) and the columns that cannot be converted into Boolean variables
\item Then, it deletes the rows in which missing values remain
}

 Finally, the remaining data are converted into Boolean variables.
 It is possible to keep track of the deleted rows.
}
\keyword{internal}
