% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/normalize.R
\docType{methods}
\encoding{UTF-8}
\name{normalize}
\alias{normalize}
\alias{normalize,ANY-method}
\alias{normalize,numeric,character,ANY-method}
\title{Unity-based normalization}
\usage{
normalize(x, method = "range")

\S4method{normalize}{ANY}(x, method = "range")
}
\arguments{
\item{x}{is a vector to be normalized.}

\item{method}{A string for the method used for normalization. Default is \code{method = "range"}, which brings the values into the range [0,1]. See details for other implemented methods.}
}
\value{
Normalized values in an object of the same class as \code{x}.
}
\description{
Normalizes as feature scaling \code{min - max}, or unity-based normalization typically used to bring the values into the range [0,1].
}
\details{
This approach may also be generalized to restrict the range of values to any arbitrary values \code{a}  and  \code{b}, using: \deqn{X' = a + \frac{(x - x_{min})(b - a)}{(x_{max} - x_{min})}}.
}
\examples{
x <- sample(10)
normalize(x)

# equivalently to
(x-min(x))/(max(x)-min(x))
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\seealso{
\code{\link{svTransform}}, \code{\link{scale}}.
}
\keyword{Rescaling}
\keyword{Transformation}

