% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Proportionality.R
\docType{methods}
\name{Proportionality}
\alias{Disproportionality}
\alias{Proportionality}
\alias{Proportionality.default}
\title{Indexes of (Disproportionality) Proportionality}
\usage{
Proportionality(v, s, index = "Gallagher", ...)

\method{Proportionality}{default}(v, s, index = "Gallagher", margin = 1,
  ...)
}
\arguments{
\item{v}{a numeric vector with the percentage share of votes obtained by each party.}

\item{s}{a numeric vector with the percentage share of seats obtained by each party.}

\item{index}{the desired method or type of index, see details below for the correct name.}

\item{margin}{The margin for which the index is computed.}

\item{\dots}{additional arguments (currently ignored)}
}
\value{
Each iteration returns a single score.
}
\description{
Calculates several indexes of (dis)-proportionality, which are for the most part used to show the relationship of votes to seats.
}
\details{
The following measures are available:
\itemize{
\item {Loosemore-Hanby} {(Percent) Loosemore-Hanby Index of disproportionality}
\item {Rae} {(Percent) Rae Index of disproportionality}
\item {Cox-Shugart} { Cox-Shugart Index of proportionality}
\item {Inv.Cox-Shugart} { The inverted Cox-Shugart index}
\item {Farina} { Farina index of proportionality, aka cosine proportionality score}
\item {"Gallagher" } { (Percent) Gallagher index of disproportionality}
\item {"Inv.Gallagher" } { The inverse of Gallagher index}
\item {"Grofman" } { Grofman index of proportionality}
\item {"Inv.Grofman" } { Grofman index of proportionality}
\item {"Lijphart" } { Lijphart index of proportionality}
\item {"Inv.Rae" } { The inverse of Rae index}
\item {"Rose" } { Rose index of disproportionality}
\item {"Inv.Rose" } { The inverse of Rose index}
\item {"Sainte-Lague" } { Sainte-Lague index of disproportionality}
\item {"DHondt" } { D'Hondt index of proportionality}
\item {"Gini" } { Gini index of disproportionality}
\item {"Monroe" } { Monroe index of inequity}
}
}
\examples{
#' # 2012 Queensland state elecion
pvotes= c(49.65, 26.66, 11.5, 7.53, 3.16, 1.47)
pseats = c(87.64, 7.87, 2.25, 0.00, 2.25, 0.00)

Proportionality(pvotes, pseats) # default is Gallagher

Proportionality(pvotes, pseats, index="Rae")

# Proportionality(pvotes, pseats, index="Cox-Shugart")

# 2012 Quebec provincial election:
pvotes = c(PQ=31.95, Lib=31.20, CAQ=27.05, QS=6.03, Option=1.89, Other=1.88)
pseats = c(PQ=54, Lib=50, CAQ=19, QS=2, Option=0, Other=0)

Proportionality(pvotes, pseats, index="Rae")

}
\author{
Daniel Marcelino \email{dmarcelino@live.com}
}
\references{
Duncan, O. and Duncan, B. (1955) A methodological analysis of segregation indexes. \emph{American Sociological Review} 20:210-7.

Gallagher, M. (1991) Proportionality, disproportionality and electoral systems. Electoral Studies 10(1):33-51.

Loosemore, J. and Hanby, V. (1971) The theoretical limits of maximum distortion: Som analytical expressions for electoral systems. \emph{British Journal of Political Science} 1:467-77.

Koppel, M., and A. Diskin. (2009) Measuring disproportionality, volatility and malapportionment: axiomatization and solutions. Social Choice and Welfare 33, no. 2: 281-286.

Rae, D. (1967) \emph{The Political Consequences of Electoral Laws.} London: Yale University Press.

Rose, Richard, Neil Munro and Tom Mackie (1998) \emph{ Elections in Central and Eastern Europe Since 1990.} Glasgow: Centre for the Study of Public Policy, University of Strathclyde.

Taagepera, R., and B. Grofman. Mapping the indices of seats-votes disproportionality and inter-election volatility. Party Politics 9, no. 6 (2003): 659-77.
}
\seealso{
\code{\link{PoliticalDiversity}}, \code{\link{LargestRemainders}}, \code{\link{HighestAverages}}. For more details, see the Indices vignette: \code{vignette("Indices", package = "SciencesPo")}.
}

