% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geoms.R
\docType{data}
\encoding{UTF-8}
\name{geom_lollipop}
\alias{GeomLollipop}
\alias{geom_lollipop}
\title{Lollipop charts}
\usage{
geom_lollipop(mapping = NULL, data = NULL, ..., horizontal = FALSE,
  point.colour = NULL, point.size = NULL, stem.colour = NULL,
  stem.size = NULL, na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{horizontal}{If is \code{FALSE} (the default), the function
will draw the lollipops up from the X axis (i.e. it will set \code{xend}
to \code{x} & \code{yend} to \code{0}). If \code{TRUE}, it wiill set
\code{yend} to \code{y} & \code{xend} to \code{0}). Make sure you map the
\code{x} & \code{y} aesthetics accordingly. This parameter helps avoid
the need for \code{coord_flip()}.}

\item{point.colour}{the colour of the point}

\item{point.size}{the size of the point}

\item{stem.colour}{the colour of the stem}

\item{stem.size}{the size of the stem}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning. If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
The lollipop geom is used to create lollipop charts.
Lollipop charts are the creation of Andy Cotgreave going back to 2011. They
are a combination of a thin segment, starting at with a dot at the top and are a
suitable alternative to or replacement for bar charts.

Geom Proto
}
\details{
Use the \code{horizontal} parameter to abate the need for \code{coord_flip()}
(see the \code{Arguments} section for details).
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "point")}
}
\examples{

df <- data.frame(trt=LETTERS[1:10],
                 value=seq(100, 10, by=-10))

ggplot(df, aes(trt, value)) + geom_lollipop()

ggplot(df, aes(value, trt)) + geom_lollipop(horizontal=TRUE)
}
\keyword{datasets}
\keyword{ggplot2}

