% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.fluency.R
\name{sim.fluency}
\alias{sim.fluency}
\title{Simulates a verbal fluency binary response matrix}
\usage{
sim.fluency(nodes)
}
\arguments{
\item{nodes}{Numeric.
Number of nodes to simulate in data}
}
\value{
A binary matrix with \code{p} (participants) by \code{n} (nodes)
}
\description{
Simulates verbal fluency data based on the number of
nodes in the desired network. Participants are 5 percent greater than
the maximum simulated fluency response given. The summed total of
each response is simulated from a gamma distribution with a
shape of .25 and rate of 1 (see \code{\link{pgamma}}). Using these
sums, participants responses are simulated with a probability of giving
a response as the total of the summed response over the number of participants.
}
\details{
Simulates data
}
\examples{
# Simulate data for 50 nodes
sim.fluency(nodes = 50)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
