\name{panelmatch}
\alias{panelmatch}

\title{Confidence ellipses around products based on panel descriptions}

\description{Comparison of panels.}

\usage{
panelmatch(donnee, col.p, col.j, firstvar, 
    alpha = 0.05, coord = c(1,2), scale.unit = TRUE, nbsimul = 500, 
    nbchoix = NULL, bloc = NULL, name.bloc = NULL, 
    centerbypanelist = TRUE, 
    scalebypanelist = FALSE, name.panelist = FALSE, cex = 1, 
    color = NULL, hierar = NULL)
}

\arguments{
  \item{donnee}{a data frame made up of at least two qualitative variables 
  (\emph{product}, \emph{panelist}) and a set of quantitative variables (sensory descriptors)}  
  \item{col.p}{the position of the \emph{product} variable}
  \item{col.j}{the position of the \emph{panelist} variable}
  \item{firstvar}{the position of the first sensory descriptor}
  \item{alpha}{the confidence level of the ellipses}
  \item{coord}{a length 2 vector specifying the components to plot}
  \item{scale.unit}{boolean, if T the descriptors are scaled to unit variance}
  \item{nbsimul}{the number of simulations (corresponding to the number of virtual panels) used to compute the ellipses}
  \item{nbchoix}{the number of panelists forming a virtual panel, by default the number of panelists in the original panel}  
  \item{bloc}{the number of groups of variables when multiple factor analysis is performed (by default this parameter equals NULL and a PCA is performed)}  
  \item{name.bloc}{the names of the groups of variables when mfa is performed (if \code{bloc} differs from NULL)}  
  \item{centerbypanelist}{boolean, if T center the data by panelist before the construction of the axes}
  \item{scalebypanelist}{boolean, if T scale the data by panelist before the construction of the axes (by default, FALSE
  is assigned to that parameter)}
  \item{name.panelist}{boolean, if T then the name of each panelist is displayed on the \code{plotpanelist} graph (by default, FALSE
  is assigned to that parameter)}
  \item{cex}{cf. function \code{\link{par}} in the \pkg{graphics} package}
 \item{color}{a vector with the colors used; by default there are 35 colors defined}
 \item{hierar}{hierarchy in the variable (see \code{hmfa})}
}


\details{
}
\value{
A list containing the following elements:
  \item{eig}{a matrix with the component of the factor analysis (in row) and the eigenvalues, the inertia and the cumulative inertia for each component}
  \item{coordinates}{a list with: the coordinates of the products with respect to the panel and to each panelists
 and the coordinates of the \emph{partial} products with respect to the panel and to each panelists}
  \item{hotelling}{Returns a matrix with the P-values of the Hotelling's T2 tests for each pair of products: this matrix allows to find the
product which are significatnly different for the 2-components sensory description}

Returns a graph of the products as well as a correlation circle of the descriptors.\cr

Returns a graph where each product is displayed with respect to a panel and to each panelist composing
the panel; products described by the panel are displayed as square, they are displayed as circle when
they are described by each panelist.\cr

Returns a graph where each product is circled by its confidence ellipse generated by virtual panels.
When a Multiple Factor Analysis is performed, returns a graph where each partial product is circled by its confidence ellipse generated by virtual panels.\cr

} 

\seealso{ \code{\link{panellipse}}, \code{\link{panellipse.session}}}

\references{
Husson F., Le Dien S. & Pags J.  (2005). Confidence ellipse for the sensory profiles obtained by Principal Components Analysis. \emph{Food Quality and Preference}.  16 (3), 245-250. \cr
Pags J. & Husson F. (2005). Multiple Factor Analysis with confidence ellipses: a methodology to study the relationships between sensory and instrumental data. To be published in \emph{Journal of Chemometrics}.
}
\author{Franois Husson}

\examples{
\dontrun{
data(chocolates)
Panel1= chocolates[chocolates[,1]<11,]
Panel2= chocolates[(chocolates[,1]<21)&(chocolates[,1]>10),]
Panel3= chocolates[chocolates[,1]>20,]
res <- panelmatch(list(Panel1,Panel2,Panel3), col.p = 4, col.j = 1, firstvar = 5)
}
}
\keyword{multivariate}
