% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SentimentDictionary.R
\name{print.SentimentDictionaryWordlist}
\alias{print.SentimentDictionaryWordlist}
\alias{print.SentimentDictionaryBinary}
\alias{print.SentimentDictionaryWeighted}
\title{Output content of sentiment dictionary}
\usage{
\method{print}{SentimentDictionaryWordlist}(x, ...)

\method{print}{SentimentDictionaryBinary}(x, ...)

\method{print}{SentimentDictionaryWeighted}(x, ...)
}
\arguments{
\item{x}{Sentiment dictionary of type \code{\link{SentimentDictionaryWordlist}}, 
\code{\link{SentimentDictionaryBinary}} or \code{\link{SentimentDictionaryWeighted}}}

\item{...}{Additional parameters passed to specific sub-routines}
}
\description{
Prints entries of sentiment dictionary to the screen
}
\examples{
print(SentimentDictionary(c("uncertain", "possible", "likely")))
print(SentimentDictionary(c("increase", "rise", "more"),
                          c("fall", "drop")))
print(SentimentDictionary(c("increase", "decrease", "exit"),
                          c(+1, -1, -10),
                          rep(NA, 3)))
}
\seealso{
\code{\link{summary}} for showing a brief summary
}
\keyword{dictionary}
